% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6_question.R
\name{Question}
\alias{Question}
\title{R6 Class representing a LimeSurvey question}
\description{
R6 Class representing a LimeSurvey question

R6 Class representing a LimeSurvey question
}
\details{
A question has at least a code and a primary language.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{code}}{The code of the question.}

\item{\code{id}}{The identifier of the question (a unique number in a survey)}

\item{\code{type}}{The question type.}

\item{\code{lsType}}{The question type in LimeSurvey's format.}

\item{\code{questionTexts}}{The question text(s) in all languages.}

\item{\code{helpTexts}}{The question help text(s) in all languages.}

\item{\code{relevance}}{The relevance.}

\item{\code{validation}}{The question's validation.}

\item{\code{language}}{The primary language of the question.}

\item{\code{answerOptions}}{The answer options in the question.}

\item{\code{subquestions}}{The subquestions in the question.}

\item{\code{mandatory}}{Whether the question is mandatory (\code{Y} or \code{N}).}

\item{\code{other}}{Whether the question has an 'other' option (\code{Y} or \code{N}).}

\item{\code{otherReplaceTexts}}{If the question has an 'other' option, its
label if the default label should be overwritten (multilingual).}

\item{\code{default}}{The default value.}

\item{\code{same_default}}{Not entirely sure what this does.}

\item{\code{array_filter}}{The question code of the array filter question
to apply.}

\item{\code{cssclass}}{The CSS class(es) to apply to this question.}

\item{\code{hide_tip}}{Whether to hide the tip (\code{Y} or \code{N}).}

\item{\code{otherOptions}}{Any additional options, stored as a named list
by assigning \code{as.list(...)}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Question$new()}}
\item \href{#method-add_answer_option}{\code{Question$add_answer_option()}}
\item \href{#method-add_subquestion}{\code{Question$add_subquestion()}}
\item \href{#method-clone}{\code{Question$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new question object. Most of this text comes directly
from the TSV manual page at
https://manual.limesurvey.org/Tab_Separated_Value_survey_structure, so
please see that page for more details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Question$new(
  code,
  type = NULL,
  lsType = NULL,
  id = NULL,
  questionTexts = "",
  helpTexts = "",
  relevance = 1,
  validation = "",
  mandatory = "N",
  other = "N",
  otherReplaceTexts = "",
  default = "",
  same_default = "0",
  array_filter = "",
  cssclass = "",
  hide_tip = "",
  language = "en",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{code}}{The question code.}

\item{\code{type}}{The human-readable question type.}

\item{\code{lsType}}{The type as LimeSurvey type (see
https://manual.limesurvey.org/Question_object_types).}

\item{\code{id}}{The identifier of the question (in a survey).}

\item{\code{questionTexts}}{The question text(s).}

\item{\code{helpTexts}}{The help text(s).}

\item{\code{relevance}}{The question's relevance equation.}

\item{\code{validation}}{The question's validation.}

\item{\code{mandatory}}{Whether the question is mandatory (\code{Y} or \code{N});.}

\item{\code{other}}{Whether the question has an 'other' option (\code{Y} or \code{N}).}

\item{\code{otherReplaceTexts}}{If the question has an 'other' option, its
label if the default label should be overwritten (multilingual).}

\item{\code{default}}{The default value.}

\item{\code{same_default}}{\code{Y} for true, in which case any default value set
for the primary language applies to other languages.}

\item{\code{array_filter}}{The question code of the array filter question
to apply.}

\item{\code{cssclass}}{The CSS class(es) to apply to this question.}

\item{\code{hide_tip}}{Whether to hide the tip (\code{Y} or \code{N}).}

\item{\code{language}}{The question's primary language.}

\item{\code{...}}{Any additional options, stored as a named list in the
\code{otherOptions} property by assigning \code{as.list(...)}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Survey} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_answer_option"></a>}}
\if{latex}{\out{\hypertarget{method-add_answer_option}{}}}
\subsection{Method \code{add_answer_option()}}{
Add an answer option to a question. Most of this text comes directly
from the TSV manual page at
https://manual.limesurvey.org/Tab_Separated_Value_survey_structure, so
please see that page for more details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Question$add_answer_option(code, optionTexts, type.scale = 0, relevance = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{code}}{The answer option code.}

\item{\code{optionTexts}}{The answer option text(s).}

\item{\code{type.scale}}{\code{0} or \code{1} (e.g. for dual-scale; 'scale_id').}

\item{\code{relevance}}{If using assessment option, this is the assessment
value for the answer ('assessment_value').}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisibly, the question object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_subquestion"></a>}}
\if{latex}{\out{\hypertarget{method-add_subquestion}{}}}
\subsection{Method \code{add_subquestion()}}{
Add a subquestion to a question. Most of this text comes directly from
the TSV manual page at
https://manual.limesurvey.org/Tab_Separated_Value_survey_structure, so
please see that page for more details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Question$add_subquestion(
  code,
  subquestionTexts,
  relevance = "",
  helpTexts = NULL,
  type.scale = 0,
  validation = "",
  mandatory = "",
  default = "",
  same_default = ""
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{code}}{The subquestions code.}

\item{\code{subquestionTexts}}{The subquestion text(s).}

\item{\code{relevance}}{When to show this subquestion.}

\item{\code{helpTexts}}{As far as I know not yet implemented in LimeSurvey;
but the TSV help page says "(Future) to support subquestion-level help".}

\item{\code{type.scale}}{\code{0} or \code{1}, depending upon question type (e.g. array
text will have two scales)0 or 1, depending upon question type (e.g.
array text will have two scales)."}

\item{\code{validation}}{As far as I know not yet implemented in LimeSurvey;
but the TSV help page says "(Future) to support subquestion-level
regular expression validation (e.g. for address parts)"}

\item{\code{mandatory}}{As far as I know not yet implemented in LimeSurvey;
but the TSV help page says "(Future) to support subquestion-level
mandatory (e.g. make only a few subquestions mandatory)"}

\item{\code{default}}{If set, then this is the default value for the
subquestion (inserted into defaultvalues table).}

\item{\code{same_default}}{If set, then the default for the primary language
is used for all other languages.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisibly, the question object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Question$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
