% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_events.R
\name{plot_events_single}
\alias{plot_events_single}
\title{Plot Events as Bars}
\usage{
plot_events_single(e, cols, xlim = NULL, ylim = NULL, xticks = NULL,
  yticks = NULL, xtick.labels = NULL, ytick.labels = NULL, main = NA,
  xlab = NA, ylab = NA, plot.grid = FALSE, sigfigs = c(3, 3),
  col = grDevices::grey.colors(length(cols)), border = par("fg"),
  lty = par("lty"), lwd = par("lwd"), xpd = FALSE, ...)
}
\arguments{
\item{e}{An event table.}

\item{cols}{Names or indices of the event table columns to plot together as stacked bars.}

\item{xlim, ylim}{Limits for the x and y axes. If \code{NULL}, limits are set to the range of the data and the y limits extended as needed to include 0.}

\item{xticks, yticks}{The values to label on the x and y axes. If \code{NULL}, only the min and max x and y are labeled (and 0 as needed for y). If \code{\link{axTicks}}, the function will be used to generate R default tick marks.}

\item{xtick.labels, ytick.labels}{Labels for the x and y tick positions.}

\item{main}{An overall title for the plot.}

\item{xlab, ylab}{Titles for the x and y axes.}

\item{plot.grid}{If \code{TRUE}, a lined horizontal grid is plotted at the yticks.}

\item{sigfigs}{The maximum significant figures to use for the x and y axis labels.}

\item{col}{Color(s) for the bars. If \code{NULL}, bars are transparent. By default, a grey palette is used.}

\item{border}{Color(s) for bar borders. Use border = NA to omit borders.}

\item{lty}{Line type(s) for bar borders.}

\item{lwd}{Line width(s) for bar borders.}

\item{xpd}{Logical value or \code{NA}. If \code{FALSE}, all plotting is clipped to the plot region, if \code{TRUE}, all plotting is clipped to the figure region, and if \code{NA}, all plotting is clipped to the device region.}

\item{...}{Additional arguments passed to \code{\link{plot}}.}
}
\description{
Plots event table columns as vertical bars.
}
\details{
The specified event table columns are plotted together as stacked bars. Negative and positive values are stacked seperately from the \code{y = 0} baseline. Events with \code{NA} are not shown, differentiating them from zero-valued events which are drawn as thin black lines. Point events are drawn as thin vertical lines. Overlapping events are drawn as overlapping bars, so it is best to use \code{\link{sample_events}} with non-overlapping bins to flatten the data before plotting.
}
\seealso{
\code{\link{plot_events}}.
}
\keyword{internal}
