% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gloss_example.R
\name{gloss_example}
\alias{gloss_example}
\title{Gloss an example}
\usage{
gloss_example(
  transliteration,
  glosses,
  free_translation = "",
  comment = "",
  orthography = "",
  line_length = 70,
  italic_transliteration = TRUE,
  drop_transliteration = FALSE,
  intext = FALSE
)
}
\arguments{
\item{transliteration}{character vector of the length one for the transliteration line.}

\item{glosses}{character vector of the length one for the glosses line.}

\item{free_translation}{character vector of the length one for the free translation line.}

\item{comment}{character vector of the length one for the comment line (under the free translation line).}

\item{orthography}{character vector of the length one for the orthography line (above translation).}

\item{line_length}{integer vector of the length one that denotes maximum number of characters per one line.}

\item{italic_transliteration}{logical variable that denotes, whether user wants to italicize your example.}

\item{drop_transliteration}{logical variable that denotes, whether user wants to have an example without transliteration.}

\item{intext}{logical variable that denotes, whether example should be considered as part of the text (\code{TRUE}) or as a standalone paragraph (\code{FALSE})}
}
\value{
html/latex output(s) with glossed examples.
}
\description{
Creates an interlinear glossed example for linguistics.
}
\examples{
gloss_example("bur-e-**ri** c'in-ne-s:u",
               "fly-NPST-**INF** know-HAB-NEG",
               "I cannot fly. (Zilo Andi, East Caucasian)",
               comment = "(lit. do not know how to)")

gloss_example("bur-e-**ri** c'in-ne-s:u",
               "fly-NPST-**INF** know-HAB-NEG",
               "I cannot fly.",
               intext = TRUE)

}
\author{
George Moroz <agricolamz@gmail.com>
}
