% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_not_linter.R
\name{expect_not_linter}
\alias{expect_not_linter}
\title{Require usage of \code{expect_false(x)} over \code{expect_true(!x)}}
\usage{
expect_not_linter()
}
\description{
\code{\link[testthat:logical-expectations]{testthat::expect_false()}} exists specifically for testing that an output is
\code{FALSE}. \code{\link[testthat:logical-expectations]{testthat::expect_true()}} can also be used for such tests by
negating the output, but it is better to use the tailored function instead.
The reverse is also true -- use \code{expect_false(A)} instead of
\code{expect_true(!A)}.
}
\examples{
# will produce lints
lint(
  text = "expect_true(!x)",
  linters = expect_not_linter()
)

# okay
lint(
  text = "expect_false(x)",
  linters = expect_not_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=package_development_linters]{package_development}, \link[=readability_linters]{readability}
}
