% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exclude.R
\name{exclude}
\alias{exclude}
\title{Exclude lines or files from linting}
\usage{
exclude(lints, exclusions = settings$exclusions, linter_names = NULL, ...)
}
\arguments{
\item{lints}{that need to be filtered.}

\item{exclusions}{manually specified exclusions}

\item{linter_names}{character vector of names of the active linters, used for parsing inline exclusions.}

\item{...}{additional arguments passed to \code{\link[=parse_exclusions]{parse_exclusions()}}}
}
\description{
Exclude lines or files from linting
}
\details{
Exclusions can be specified in three different ways.
\enumerate{
\item Single line in the source file. default: \verb{# nolint}, possibly followed by a listing of linters to exclude.
If the listing is missing, all linters are excluded on that line. The default listing format is
\verb{# nolint: linter_name, linter2_name.}. There may not be anything between the colon and the line exclusion tag
and the listing must be terminated with a full stop (\code{.}) for the linter list to be respected.
\item Line range in the source file. default: \verb{# nolint start}, \verb{# nolint end}. \verb{# nolint start} accepts linter
lists in the same form as \verb{# nolint}.
\item Exclusions parameter, a list with named and/or unnamed entries.
Outer elements have the following characteristics:
\enumerate{
\item Unnamed elements specify filenames or directories.
\item Named elements are a vector or list of line numbers, with \code{Inf} indicating 'all lines'.
The name gives a path relative to the config.
\enumerate{
\item Unnamed elements denote exclusion of all linters in the given path or directory.
\item Named elements, where the name specifies a linter, denote exclusion for that linter.
For convenience, a vector can be used in place of a list whenever it would not introduce ambiguity, e.g.
a character vector of files to exclude or a vector of lines to exclude.
}
}
}
}
