% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xp_utils.R
\name{xp_call_name}
\alias{xp_call_name}
\title{Get the name of the function matched by an XPath}
\usage{
xp_call_name(expr, depth = 1L, condition = NULL)
}
\arguments{
\item{expr}{An \code{xml_node} or \code{xml_nodeset}, e.g. from \code{\link[xml2:xml_find_all]{xml2::xml_find_all()}}.}

\item{depth}{Integer, default \code{1L}. How deep in the AST represented by \code{expr}
should we look to find the call? By default, we assume \code{expr} is matched
to an \verb{<expr>} node under which the corresponding \verb{<SYMBOL_FUNCTION_CALL>}
node is found directly. \code{depth = 0L} means \code{expr} is matched directly
to the \code{SYMBOL_FUNCTION_CALL}; \code{depth > 1L} means \code{depth} total \verb{<expr>}
nodes must be traversed before finding the call.}

\item{condition}{An additional (XPath condition on the \code{SYMBOL_FUNCTION_CALL}
required for a match. The default (\code{NULL}) is no condition. See examples.}
}
\description{
Often, it is more helpful to tailor the \code{message} of a lint to record
which function was matched by the lint logic. This function encapsulates
the logic to pull out the matched call in common situations.
}
\examples{
xml_from_code <- function(str) {
  xml2::read_xml(xmlparsedata::xml_parse_data(parse(text = str, keep.source = TRUE)))
}
xml <- xml_from_code("sum(1:10)")
xp_call_name(xml, depth = 2L)

xp_call_name(xml2::xml_find_first(xml, "expr"))

xml <- xml_from_code(c("sum(1:10)", "sd(1:10)"))
xp_call_name(xml, depth = 2L, condition = "text() = 'sum'")

}
