% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{map_along_dim}
\alias{map_along_dim}
\alias{map_along_rows}
\alias{map_along_cols}
\title{Apply a function across subsets along an array dimension}
\usage{
map_along_dim(X, .dim, .f, ..., .drop = NULL)

map_along_rows(X, .f, ..., .drop = NULL)

map_along_cols(X, .f, ..., .drop = NULL)
}
\arguments{
\item{X}{an R array}

\item{.dim}{which dimension to map along. Passed on to \code{\link[=split_along_dim]{split_along_dim()}},
and accepts all the same inputs. Valid inputs include
\itemize{
\item positive integers (index position(s) of dimension),
\item negative integers (index positions(s) of dimensions, counting from the back), or
\item character vector (corresponding to array dimnames)
}}

\item{.f}{A function, string of a function name, or \code{purrr} style compact lambda syntax (e.g, \code{~.x + 1})}

\item{...}{passed on to \code{.f()}}

\item{.drop}{passed on to \code{[} when subsetting the array.}
}
\value{
An R list
}
\description{
\code{map_along_dim(X, dim, func)} is a simple wrapper around \code{split_along_dim(X, dim) \%>\% map(func)}. It is conceptually and functionally equivalent to
\code{base::apply()}, with the following key differences:
\itemize{
\item it is guaranteed to return a list (\code{base::apply()} attempts to simplify the
output to an array, sometimes unsuccessfully, making the output unstable)
\item it accepts the compact lambda notation \code{~.x} just like in \code{\link[purrr:map]{purrr::map}}
(and \code{\link[=modify_along_dim]{modify_along_dim()}})
}
}
\examples{
X <- matrix2(letters[1:15], ncol = 3)

apply(X, 1, function(x) paste(x, collapse = ""))   # simplifies to a vector
map_along_dim(X, 1, ~paste(.x, collapse = ""))     # returns a list

identical(
  map_along_rows(X, identity),
  map_along_dim(X, 1, identity)) # TRUE

identical(
  map_along_cols(X, identity),
  map_along_dim(X, -1, identity)) # TRUE
}
