% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dalex_shortcut.R
\name{local_approximation}
\alias{local_approximation}
\title{Fit local model around the observation: shortcut for DALEX explainer objects}
\usage{
local_approximation(explainer, observation, target_variable_name,
  n_new_obs, local_model = "regr.lm", select_variables = F,
  predict_type = "response", kernel_type = gaussian_kernel, ...)
}
\arguments{
\item{explainer}{a model to be explained, preprocessed by the DALEX::explain function}

\item{observation}{a new observation for which predictions need to be explained}

\item{target_variable_name}{name of the response variablea as a character}

\item{n_new_obs}{Number of observation in the simulated dataset}

\item{local_model}{Character specyfing mlr learner to be used as a local model}

\item{select_variables}{If TRUE, variable selection will be performed while
fitting the local linear model}

\item{predict_type}{Argument passed to mlr::makeLearner() argument "predict.type"
while fitting the local model. Defaults to "response"}

\item{kernel_type}{Function which will be used to calculate distances from
simulated observation to explained instance}

\item{...}{Arguments to be passed to sample_locally2 function}
}
\value{
object of class live_explainer. More details in fit_explanation2 function help.
}
\description{
Fit local model around the observation: shortcut for DALEX explainer objects
}
\examples{
\dontrun{
data('wine')
library(randomForest)
library(DALEX)
rf <- randomForest(quality~., data = wine)
expl <- explain(rf, wine, wine$quality)
live_expl <- local_approximation(expl, wine[5, ], "quality", 500)
}

}
