% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/historical_average_forc.R
\name{historical_average_forc}
\alias{historical_average_forc}
\title{Historical average forecast}
\usage{
historical_average_forc(
  avg_function,
  realized_vec,
  h_ahead,
  estimation_end,
  time_vec = NULL,
  estimation_window = NULL
)
}
\arguments{
\item{avg_function}{Character, either "mean" or "median". Selects whether
forecasts are made using the historical mean or historical median of
the series.}

\item{realized_vec}{Vector of realized values. This is the series that is
being forecasted.}

\item{h_ahead}{Integer representing the number of periods ahead that is being
forecasted.}

\item{estimation_end}{Value of any class representing when to end the initial
average estimation period and begin forecasting.}

\item{time_vec}{Vector of any class that is equal in length to the
\code{realized_vec} vector.}

\item{estimation_window}{Integer representing the number of past periods
that the historical average should be estimated over in each period.}
}
\value{
\code{\link{Forecast}} object that contains the historical average
forecast.
}
\description{
\code{historical_average_forc} takes an average function, a vector of realized
values, an integer number of periods ahead to forecast, a period to end the initial
average estimation and begin forecasting, an optional vector of time data
associated with the realized values, and an optional integer number of past
periods to estimate the average over.  The historical average is originally
calculated with realized values up to \code{estimation_end} minus the number
of periods specified in \code{estimation_window}. If \code{estimation_window}
is left \code{NULL} then the historical average is calculated with all available
realized values up to \code{estimation_end}. In each period the historical
average is set as the \code{h_ahead} period ahead forecast. This process is
iteratively repeated for each period after \code{estimation_end} with the
historical average updating in each period as more information would have
become available to the forecaster. Returns a historical average forecast where
the \code{h_ahead} period ahead forecast is simply the historical average or
rolling window average of the series being forecasted.
}
\examples{
date <- as.Date(c("2010-03-31", "2010-06-30", "2010-09-30", "2010-12-31",
                  "2011-03-31", "2011-06-30", "2011-09-30", "2011-12-31", 
                  "2012-03-31", "2012-06-30"))
y  <- c(1.09, 1.71, 1.09, 2.46, 1.78, 1.35, 2.89, 2.11, 2.97, 0.99)
data <- data.frame(date, y)

historical_average_forc(
  avg_function = "mean",
  realized_vec = data$y,
  h_ahead = 2L,
  estimation_end = as.Date("2011-03-31"),
  time_vec = data$date,
  estimation_window = 4L
)
 
historical_average_forc(
  avg_function = "median",
  realized_vec = data$y,
  h_ahead = 4L,
  estimation_end = 4L
)
 
}
\seealso{
For a detailed example see the help vignette:
\code{vignette("lmForc", package = "lmForc")}
}
