% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploratory_gwas_functions.R
\name{linkdis.plots}
\alias{linkdis.plots}
\title{Linkage Disequilibrium heatmap plot}
\usage{
linkdis.plots (crossobj, heterozygotes, chr)
}
\arguments{
\item{crossobj}{An object of class = cross obtained from the gwas.cross
function from this package, or the read.cross
function from r/qtl package (Broman and Sen, 2009).
This file contains phenotypic means, genotypic marker score, and genetic map.}

\item{heterozygotes}{Logical value indicating whether heterozygotes are present.}

\item{chr}{A vector containing chromosome number to use.}
}
\value{
Return a Linkage Disequilibrium heatmap plot.
}
\description{
Performs a Linkage Disequilibrium heatmap plot for the GWAS analysis.
Non-random association of markers (linkage disequilibrium) are estimated
as Lewont in \eqn{'/c}s \eqn{D'/c} (Lewontin\eqn{'/c}s, 1964) with
the LD function of the genetics package (Warnes and Leisch, 2005) and
isualized with the LD.heatmap package (Shin et al., 2015). \eqn{D'/c}
is estimated as: \eqn{D'/c = D/DMax} where D= pAB - pApB,
DMax=Min (pApb, papB), and pA is the probability of the A allele for marker 1,
pa=1-pA, pB is the probability of the B allele for marker 2, pb=1-pB,
and pAB is the probability of AB alleles.
}
\details{
The function returns the LD.heatmap for the chromosomes selected.
}
\note{
When large data sets are being used, linkdis.plots is encourage to be
performed for each chromosome separately.
}
\examples{
\dontrun{
data (QA_geno)
data (QA_map)
data (QA_pheno)

P.data <- QA_pheno
G.data <- QA_geno
map.data <- QA_map

cross.data <- gwas.cross (P.data, G.data, map.data,
cross='gwas', heterozygotes=FALSE)
summary (cross.data)

LD.plots

linkdis.plots(crossobj = cross.data, heterozygotes = FALSE, chr = c('1', '7'))
}

}
\author{
Lucia Gutierrez
}
\references{
Comadran J, Thomas W, van Eeuwijk F, Ceccarelli S, Grando S,
            Stanca A, Pecchioni N, Akar T, Al-Yassin A,
            Benbelkacem A, Ouabbou H, Bort J, Romagosa I,
            Hackett C, Russell J (2009) Patterns of genetic diversity
            and linkage disequilibrium in a highly structured
            Hordeum vulgare association-mapping population for
            the Mediterranean basin. Theor Appl Genet 119:175-187

            Warnes, G; Leisch, F. 2005. Genetics: Population genetics R package
            1.2.0. Lewontin, R. 1964. The interaction of selection and linkage.
             I. General Considerations: Heterotic models. Genetics 49: 49-67.
}
\seealso{
gwas.analysis
}

