% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosis_functions.R
\name{mq.diagnostics}
\alias{mq.diagnostics}
\title{Performs molecular markers quality diagnostics.}
\usage{
mq.diagnostics(crossobj, I.threshold = 0.1, estmarker = FALSE,
  I.quant = FALSE, p.val = 0.01, na.cutoff = 0.1)
}
\arguments{
\item{crossobj}{An object of class = cross obtained
from the qtl.cross function from this package,
or the read.cross function from r/qtl package (Broman and Sen, 2009).
This file contains phenotypic means, genotypic marker score, and genetic map.}

\item{I.threshold}{Threshold for proportion of allelic differences below which
individuals are marked as too similar, pairs that differ
more than (1-threshold) are marked as exceptioally different.
Default is set to 10 per cent (I.threshold = 0.1).}

\item{estmarker}{Logical value indicating whether a new marker map should be
estimated and plotted. If estmarker=TRUE, this is passed onto r/qtl
(Broman and Sen, 2009) and performs est.map function.
This uses the Lander-Green algorithm (i.e., the hidden Markov model technology)
to re-estimate the genetic map for an experimental cross. Default is set to FALSE.}

\item{I.quant}{Threshold indicating the quantile to identify the most
similar individuas. Default is set to FALSE.}

\item{p.val}{Significance level for the chi-square test for segregation distortion.
The default is set to p<0.01. No multiple comparison correction is performed here.}

\item{na.cutoff}{Proportion of missing data above which individuals and markers are
reported . Default is set to 10 per cent (na.cutoff = 0.1).}
}
\value{
The following reports are written to mq_reports:

1) mq_summary_markers, reports on missing data and segregation distortion.

2) mq_problems_markers, reports on duplicate or outlier genotypes.

Additionally, several diagnostic plots are performed:

1) mq_markermap_plot, this figure shows the position of all
 markers across the genome  (equivalent R/qtl: plot.map) (Broman and Sen 2009).

2) mq_genotype_plot, this figure shows marker alleles for all
individuals across thegenome (equivalent to r/qtl: geno.image)
(Broman and Sen 2009).

3) mq_missinggenotype_plot, this figure highlights missing marker scores for all
individuals across the genome (equivalent to r/qtl: plot.missing)
(Broman and Sen 2009).

4) mq_comparegenotypes_plot, this figure represents the pairwise number of alleles
shared by each pair of individuals (equivalent to r/qtl: comparegeno)
(Broman and Sen 2009).

5) mq_cf_plot, this figure represents the pairwise recombination fraction
among each pair of markers (equivalent to r/qtl: plot.rf).
(Broman and Sen 2009).

6) mq_genotypic_distortion_plot, this figure represents the -log(p-values)
of the test for segregation distortion for each marker represented by
its chromosome and position.

7) mq_identical_genotypes_plot, this figure is the histogram of the proportion of
shared alleles among each pair of individuals.

8) mq_estmarkermap_plot, this figure is a comparison between the map
provided by the user and the map estimated with the est.map function.
Will print only if estmarker=TRUE (equivalent to r/qtl: est.map,plot.map)
(Broman and Sen 2009)
}
\description{
Performs molecular markers quality diagnostic of an object of
class cross created by the qtl.cross function,
including summary description for marker distribution and coverage,
evaluating the map quality, the presence of identical individuals,
visualizing marker alleles and missing marker
scores for all individuals across the genome,
the pairwise number of alleles shared by each pair of individuals,
the pairwise recombination fraction among each pair of markers,
and a test for segregation distortion for each marker in linkage analysis.
}
\details{
Performs plots in the work directory.
}
\note{
Performs marker quality daignostics for QTL and GWAS analyses
}
\examples{
\dontrun{
data (SxM_geno)
data (SxM_map)
data (SxM_pheno)

P.data <- SxM_pheno
G.data <- SxM_geno
map.data <- SxM_map

cross.data  <- qtl.cross (P.data, G.data, map.data,
cross='gwas', heterozygotes=FALSE, env=NUL)
summary (cross.data)

jittermap (cross.data)

Marker Quality
mq.diagnostics (crossobj=cross.data,I.threshold=0.1,
             p.val=0.01,na.cutoff=0.1)
}
}
\author{
Lucia Gutierrez
}
\references{
Broman KW, Sen S (2009) A Guide to QTL Mapping with R/qtl.
            Springer, NewYork
            Hayes PM, Liu BH, Knapp SJ, Chen F, Jones B, Blake T, Franckowiak JD,
            Rasmusson DC, Sorrells
            M, Ullrich SE, Wesenberg DM, Kleinhofs A (1993)
            Quantitative trait locus effects and environmental
            interaction in a sample of North American barley
            germplasm. Theor Appl Genet 87:392-401
}
\seealso{
qtl.cross
}

