% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_lme4.R, R/bootstrap_nlme.R,
%   R/generics.R
\name{cgr_bootstrap.lmerMod}
\alias{cgr_bootstrap.lmerMod}
\alias{cgr_bootstrap.lme}
\alias{cgr_bootstrap}
\title{CGR Bootstrap for Nested LMEs}
\usage{
\method{cgr_bootstrap}{lmerMod}(model, fn, B)

\method{cgr_bootstrap}{lme}(model, fn, B)

cgr_bootstrap(model, fn, B)
}
\arguments{
\item{model}{The model object you wish to bootstrap.}

\item{fn}{A function returning the statistic(s) of interest.}

\item{B}{The number of bootstrap resamples.}
}
\value{
The returned value is an object of class "boot", compatible with the \pkg{boot}
package's \code{\link[boot]{boot}} methods.
}
\description{
Generate semi-parametric bootstrap replicates of a statistic for a nested 
linear mixed-effects model.
}
\details{
The semi-parametric bootstrap algorithm implemented was outlined by  Carpenter,  
Goldstein and Rasbash (2003). The algorithm is outlined below:
\enumerate{
  \item Obtain the parameter estimates from the fitted model and calculate
     the estimated error terms and EBLUPs.
  \item Rescale the error terms and EBLUPs so that the empirical variance of
     these quantities is equal to estimated variance components from the model.
  \item Sample independently with replacement from the rescaled estimated error 
     terms and rescaled EBLUPs.
  \item Obtain bootstrap samples by combining the samples via the fitted model equation.
  \item Refit the model and extract the statistic(s) of interest.
  \item Repeat steps 3-5 B times.
}
}
\references{
Carpenter, J. R., Goldstein, H. and Rasbash, J. (2003) A novel bootstrap 
   procedure for assessing the relationship between class size and achievement. 
   \emph{Journal of the Royal Statistical Society. Series C (Applied Statistics)}, 
   \bold{52}, 431--443.
}
\seealso{
\itemize{
  \item \code{\link{parametric_bootstrap}}, \code{\link{resid_bootstrap}},
     \code{\link{case_bootstrap}}, \code{\link{cgr_bootstrap}}, 
     \code{\link{reb_bootstrap}} for more details on a specific bootstrap.
  \item \code{\link[lme4]{bootMer}} in the \pkg{lme4} package for an 
     implementation of (semi-)parameteric bootstrap for mixed models.
  \item \code{\link[boot]{boot}}, \code{\link[boot]{boot.ci}}, and \code{\link[boot]{plot.boot}} 
     from the \pkg{boot} package.
}
}
