% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lmmsDE-method.R
\docType{methods}
\name{lmmsDE}
\alias{lmmsDE}
\title{Differential expression analysis using linear mixed effect model splines.}
\usage{
lmmsDE(data, time, sampleID, group, type,
experiment, basis, knots,keepModels, numCores)
}
\arguments{
\item{data}{\code{data.frame} or \code{matrix} containing the samples as rows and features as columns}

\item{time}{\code{numeric} vector containing the sample time point information.}

\item{sampleID}{\code{character}, \code{numeric} or \code{factor} vector containing information about the unique identity of each sample}

\item{group}{\code{character}, \code{numeric} or \code{factor} vector containing information about the group (or class) of each sample}

\item{type}{\code{character} indicating what type of analysis is to be performed. Options are \code{"time"} to identify differential expression over time, \code{"group"} to identify profiles with different baseline levels (intercepts), and \code{"time*group"} an interaction between these two . Use \code{"all"} to calculate all three types.}

\item{experiment}{\code{character} describing the experiment performed for correlation handling. Use \code{"all"} for data-driven selection of model; \code{"timecourse"} for replicated experiments with less variation in individual expression values (e.g. model organism, cell culture), \code{"longitudinal1"} for different intercepts and \code{"longitudinal2"} for different intercepts and slopes.}

\item{basis}{\code{character} string. What type of basis to use, matching one of \code{"cubic"} smoothing spline as defined by Verbyla \emph{et al.} 1999, \code{"p-spline"} Durban \emph{et al.} 2005 or a \code{"cubic p-spline"}.}

\item{knots}{can take an integer value corresponding to the number of knots for the chosen basis or by default calculated as  in Ruppert 2002. Not in use for the 'cubic' smoothing spline basis.}

\item{keepModels}{alternative \code{logical} value if you want to keep the model output. Default value is FALSE}

\item{numCores}{alternative \code{numeric} value indicating the number of CPU cores to be used for parallelization. Default value is automatically estimated.}
}
\value{
lmmsDE returns an object of class \code{lmmsde} containing the following components:
\item{DE}{\code{data.frame} returning p-values and adjusted p-values using Benjamini-Hochberg correction for multiple testing of the differential expression testing over time, group or their interaction.}
\item{modelsUsed}{\code{numeric} vector indicating the model used to fit the data. 1=linear mixed effect model spline (LMMS) with defined basis ('cubic' by default) 2 = LMMS taking subject-specific random intercept, 3 = LMMS with subject specific intercept and slope.}
\item{predTime}{\code{data.frame} containing predicted values based on linear model object or linear mixed effect model object.}
\item{predGroup}{\code{data.frame} containing predicted values based on linear model object or linear mixed effect model object.}
\item{predTime}{\code{data.frame} containing predicted values based on linear model object or linear mixed effect model object.}
\item{predTimeGroup}{\code{data.frame} containing predicted for the time*group model values based on linear model object or linear mixed effect model object.}
\item{modelTime}{a \code{list} of class \code{\link{lme}}, containing the models for every feature modelling the time effect.}
\item{modelGroup}{a \code{list} of class \code{\link{lme}}, containing the models for every feature modelling group effect. }
\item{modelTimeGroup}{a \code{list} of class \code{\link{lme}}, containing the models for every feature modelling time and group interaction effect. }
\item{type}{an object of class \code{character}, describing the test performed either time, group, time*group or all. }
\item{experiment}{an object of class \code{character} describing the model used to perform differential expression analysis.}
}
\description{
Function to fit a linear mixed effect model splines to perform differential expression analysis. The \code{\link{lmmsDE}} function fits LMM models with either a \code{cubic}, \code{p-spline} or \code{cubic p-spline} basis and compares the models to the null models. The type of basis to use is specified with the \code{basis} argument.
}
\details{
lmmsDE extends the LMMS modelling framework to permit tests between groups, across time, and for interactions between the two implemented as described in Straube \emph{et al.} 2015.
}
\examples{
\dontrun{
data(kidneySimTimeGroup)
lmmsDEtest <-lmmsDE(data=kidneySimTimeGroup$data,time=kidneySimTimeGroup$time,
              sampleID=kidneySimTimeGroup$sampleID,group=kidneySimTimeGroup$group)
summary(lmmsDEtest)}
}
\references{
Durban, M., Harezlak, J., Wand, M. P., & Carroll, R. J. (2005). \emph{Simple fitting of subject-specific curves for longitudinal data.} Stat. Med., 24(8), 1153-67.

Ruppert, D. (2002). \emph{Selecting the number of knots for penalized splines.} J. Comp. Graph. Stat. 11, 735-757

Verbyla, A. P., Cullis, B. R., & Kenward, M. G. (1999). \emph{The analysis of designed experiments and longitudinal data by using smoothing splines.} Appl.Statist, 18(3), 269-311.

Straube J., Gorse A.-D., Huang B.E., & Le Cao K.-A. (2015). \emph{A linear mixed model spline framework for analyzing time course 'omics' data} PLOSONE (accepted)
}
\seealso{
\code{\link{summary.lmmsde}}, \code{\link{plot.lmmsde}}
}

