% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_surrogate.R
\name{plot.local_surrogate_explainer}
\alias{plot.local_surrogate_explainer}
\title{Generic plot function for local surrogate explainers}
\usage{
\method{plot}{local_surrogate_explainer}(x, ..., geom = "point")
}
\arguments{
\item{x}{object of class local_surrogate_explainer}

\item{...}{other objects of class local_surrogate_explainer.
If provided, models will be plotted in rows, response levels in columns.}

\item{geom}{If "point", lines with points at the end will be plotted,
if "bar", bars will be plotted and if "arrow", arrows.}
}
\description{
Generic plot function for local surrogate explainers
}
\examples{
# Example based on apartments data from DALEX package.
library(DALEX)
library(randomForest)
library(localModel)
data('apartments')
mrf <- randomForest(m2.price ~., data = apartments, ntree = 50)
explainer <- explain(model = mrf,
                     data = apartments[, -1])
model_lok <- individual_surrogate_model(explainer, apartments[5, -1],
                                        size = 500, seed = 17)
model_lok
plot(model_lok)

}
