% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParLin_expectreg_homo_uni.R
\name{ParLin_expectreg_homo_uni}
\alias{ParLin_expectreg_homo_uni}
\title{Partially linear expectile regression with a homoscedastic error and
a univariate variable in the nonparametric function}
\usage{
ParLin_expectreg_homo_uni(
  X,
  Y,
  Z,
  omega = 0.3,
  kernel = gaussK,
  grid = seq(min(Z), max(Z), length.out = 100)
)
}
\arguments{
\item{X}{The covariates data values for the linear part (of size \eqn{n \times k}).}

\item{Y}{The response data values.}

\item{Z}{The covariate data values for the nonparametric part.}

\item{omega}{Numeric vector of level between 0 and 1 where 0.5 corresponds
to the mean.}

\item{kernel}{The kernel used to perform the estimation. In default setting,
\code{kernel=gaussK}. See details in \code{\link[locpol]{Kernels}}.}

\item{grid}{Vector of evaluation points used for the nonparametric part. In default setting, a grid of 100
equispaced grid-values on the domain of the variable \code{Z}.}
}
\value{
\code{\link{ParLin_expectreg_homo_uni}} partially linear expectile estimators
for a homoscedastic error and a univariare variable in the nonparametric part
proposed and studied by Adam and Gijbels (2021b). \code{\link{ParLin_expectreg_homo_uni}}
returns a list whose components are:
\itemize{
 \item \code{Linear} The delta estimators for the linear part
 \item \code{Nonlinear} The estimation of the nonparametric part
 according to the grid.
}
}
\description{
Formula interface for the partially linear expectile regression
using local linear expectile estimation assuming a homoscedastic error and
a univariate variable in the nonparametric function. For the nonparametric part,
the general Rule-of-Thumb bandwidth selector proposed in Adam and Gijbels (2021a)
is used. See Adam and Gijbels (2021b) for more details.
}
\examples{
library(locpol)
set.seed(123)
Z<-runif(100,-3,3)
eta_1<-rnorm(100,0,1)
X1<-(0.9*Z)+(1.5*eta_1)
set.seed(1234)
eta_2<-rnorm(100,0,2)
X2<-(0.9*Z)+(1.5*eta_2)
X<-rbind(X1,X2)

set.seed(12345)
epsilon<-rnorm(100,0,1)
delta<-rbind(0.8,-0.8)

Y<-as.numeric((t(delta)\%*\%X)+(10*sin(0.9*Z))+5*epsilon)

ParLin_expectreg_homo_uni(X=t(X),Y=Y,Z=Z,omega=0.3
,kernel=gaussK,grid=seq(min(Z),max(Z),length.out=10))

}
\references{
{

Adam, C. and Gijbels, I. (2021a). Local polynomial expectile regression.
Annals of the Institute of Statistical Mathematics doi:10.1007/s10463-021-00799-y.

Adam, C. and Gijbels, I. (2021b). Partially linear expectile regression using
local polynomial fitting. In Advances in Contemporary Statistics and Econometrics:
Festschrift in Honor of Christine Thomas-Agnan, Chapter 8, pages 139–160. Springer, New York.

}
}
