% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_genetracks.R
\name{gg_genetracks}
\alias{gg_genetracks}
\title{Plot gene tracks}
\usage{
gg_genetracks(
  locus,
  filter_gene_name = NULL,
  filter_gene_biotype = NULL,
  border = FALSE,
  cex.axis = 1,
  cex.lab = 1,
  cex.text = 0.7,
  gene_col = ifelse(showExons, "blue4", "skyblue"),
  exon_col = "blue4",
  exon_border = "blue4",
  showExons = TRUE,
  maxrows = NULL,
  text_pos = "top",
  xticks = FALSE,
  xlab = NULL,
  draw = TRUE
)
}
\arguments{
\item{locus}{Object of class 'locus' generated by \code{\link[=locus]{locus()}}.}

\item{filter_gene_name}{Vector of gene names to display.}

\item{filter_gene_biotype}{Vector of gene biotypes to be filtered. Use
\code{\link[ensembldb:EnsDb-class]{ensembldb::listGenebiotypes()}} to display possible biotypes. For example,
\code{ensembldb::listGenebiotypes(EnsDb.Hsapiens.v75)}}

\item{border}{Logical whether a bounding box is plotted.}

\item{cex.axis}{Specifies font size for axis numbering.}

\item{cex.lab}{Specifies font size for axis titles.}

\item{cex.text}{Font size for gene text.}

\item{gene_col}{Colour for gene lines.}

\item{exon_col}{Fill colour for exons.}

\item{exon_border}{Border line colour outlining exons (or genes if
\code{showExons} is \code{FALSE}). Set to \code{NA} for no border.}

\item{showExons}{Logical whether to show exons or simply show whole gene as a
rectangle. If \code{showExons = FALSE} colours are specified by \code{exon_border}
for rectangle border and \code{gene_col} for the fill colour.}

\item{maxrows}{Specifies maximum number of rows to display in gene
annotation panel.}

\item{text_pos}{Character value of either 'top' or 'left' specifying
placement of gene name labels.}

\item{xticks}{Logical whether x axis ticks and numbers are plotted.}

\item{xlab}{Title for x axis. Defaults to chromosome \code{seqname} specified
in \code{locus}.}

\item{draw}{Logical whether to draw the plot in the current viewport.}
}
\value{
A grob object.
}
\description{
Plot gene annotation tracks from \code{ensembldb} data using the grid package.
}
\details{
This function is called by \code{\link[=locus_ggplot]{locus_ggplot()}}. It can be used to plot
the gene annotation tracks on their own.
}
\examples{
if(require(EnsDb.Hsapiens.v75)) {
data(SLE_gwas_sub)
loc <- locus(SLE_gwas_sub, gene = 'IRF5', flank = c(7e4, 2e5), LD = "r2",
             ens_db = "EnsDb.Hsapiens.v75")
grid::grid.newpage()
gg_genetracks(loc)
}
}
