% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eqtl_plot.R
\name{eqtl_plot}
\alias{eqtl_plot}
\title{Locus eQTL plot}
\usage{
eqtl_plot(
  loc,
  tissue = "Whole Blood",
  eqtl_gene = loc$gene,
  scheme = "RdYlBu",
  col = NA,
  pcutoff = NULL,
  xlab = NULL,
  ylab = expression("-log"[10] ~ "P"),
  cex.axis = 0.9,
  xticks = TRUE,
  border = FALSE,
  add = FALSE,
  align = TRUE,
  legend_pos = "topright",
  ...
)
}
\arguments{
\item{loc}{Object of class 'locus' to use for plot. See \link{locus}.}

\item{tissue}{GTex tissue in which eQTL has been measured}

\item{eqtl_gene}{Gene showing eQTL effect}

\item{scheme}{Character string specifying palette for effect size showing
up/downregulation eQTL using \link[grDevices:palettes]{grDevices::hcl.colors}. Alternatively a
vector of 6 colours.}

\item{col}{Outline point colour. \code{NA} for no outlines.}

\item{pcutoff}{Cut-off for p value significance. Defaults to p = 5e-08. Set
to \code{NULL} to disable.}

\item{xlab}{x axis title.}

\item{ylab}{y axis title.}

\item{cex.axis}{Specifies font size for axis numbering.}

\item{xticks}{Logical whether x axis numbers and axis title are plotted.}

\item{border}{Logical whether a bounding box is plotted around upper and
lower plots.}

\item{add}{Logical whether to add points to an existing plot or generate a
new plot.}

\item{align}{Logical whether set \code{\link[=par]{par()}} to align the plot.}

\item{legend_pos}{Character value specifying legend position. See \code{\link[=legend]{legend()}}.}

\item{...}{Other arguments passed to \code{\link[=plot]{plot()}} for the scatter plot.}
}
\value{
No return value. Produces a scatter plot using base graphics.
}
\description{
Produces a plot of eQTL data embedded in a 'locus' class object. Intended for
use with \code{\link[=set_layers]{set_layers()}}.
}
\seealso{
\code{\link[=locus]{locus()}} \code{\link[=set_layers]{set_layers()}} \code{\link[=scatter_plot]{scatter_plot()}}
}
