% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configurations.R
\name{set_logfile}
\alias{set_logfile}
\title{Set Log File}
\usage{
set_logfile(logfile = NULL, confirm = TRUE)
}
\arguments{
\item{logfile}{Full or relative path to log file. If not provided, will write
to \verb{<tmpdir>/loggit.log}.}

\item{confirm}{Print confirmation of log file setting? Defaults to \code{TRUE}.}
}
\description{
Set the log file that loggit will write to. No logs outside of a temporary
directory will be written until this is set explicitly, as per CRAN policy.
Therefore, the default behavior is to create a file named \code{loggit.log} in
your system's temporary directory.
}
\details{
A suggested use of this function would be to call it early, to log to the
current working directory, as follows: \code{set_logfile(paste0(getwd(), "/loggit.log"))}. If you are using \code{loggit} in your package, you can wrap
this function in \code{.onLoad()} so that the logfile is set when your package
loads.
}
\examples{
set_logfile(file.path(tempdir(), "loggit.log"))

}
