% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logiBin.R
\name{createBins}
\alias{createBins}
\title{Add binned variables to data}
\usage{
createBins(binObj, df, xVars, prefix = "b_")
}
\arguments{
\item{binObj}{- An object returned by getBins or any other function in this package}

\item{df}{- A data frame}

\item{xVars}{- A vector of names of variables for which bins have to be created}

\item{prefix}{- The prefix to be added to the variable name to create the new variable. Default value is b_}
}
\value{
Returns a dataframe which adds the binned variables to the original data frame
}
\description{
This function creates a data frame with binned variables
}
\examples{
b1 <- getBins(loanData, "bad_flag", c('age', 'score', 'balance'), minCr=0.8)
loanData <- createBins(b1, loanData, c('age', 'balance'))

}
