% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pruning.R
\name{cv.prune}
\alias{cv.prune}
\title{Optimal pruning via cross-validation}
\usage{
cv.prune(
  model,
  nfolds = 10,
  scoring_rule = "deviance",
  choose = "1se",
  simplify = TRUE
)
}
\arguments{
\item{model}{A fitted \code{logicDT} model}

\item{nfolds}{Number of cross-validation folds}

\item{scoring_rule}{The scoring rule for evaluating the cross-validation
error and its standard error. For classification tasks, \code{"deviance"}
or \code{"Brier"} should be used.}

\item{choose}{Model selection scheme. If the model that minimizes the
cross-validation error should be chosen, \code{choose = "min"} should be
set. Otherwise, \code{choose = "1se"} leads to simplest model in the range
of one standard error of the minimizing model.}

\item{simplify}{Should the pruned model be simplified with regard to the
input terms, i.e., should terms that are no longer in the tree contained
be removed from the model?}
}
\value{
A list containing
  \item{\code{model}}{The new \code{logicDT} model containing the optimally
  pruned tree}
  \item{\code{cv.res}}{A data frame containing the penalties, the
  cross-validation scores and the corresponding standard errors}
  \item{\code{best.beta}}{The ideal penalty value}
}
\description{
Using a fitted \code{\link{logicDT}} model, its logic decision tree can be
optimally (post-)pruned utilizing k-fold cross-validation.
}
\details{
Similar to Breiman et al. (1984), we implement post-pruning by first
computing the optimal pruning path and then using cross-validation for
identifying the best generalizing model.

In order to handle continuous covariables with fitted regression models in
each leaf, similar to the likelihood-ratio splitting criterion in
\code{\link{logicDT}}, we propose using the log-likelihood as the impurity
criterion in this case for computing the pruning path.
In particular, for each node \eqn{t}, the weighted node impurity
\eqn{p(t)i(t)} has to be calculated and the inequality
\deqn{\Delta i(s,t) := i(t) - p(t_L | t)i(t_L) - p(t_R | t)i(t_R) \geq 0}
has to be fulfilled for each possible split \eqn{s} splitting \eqn{t} into
two subnodes \eqn{t_L} and \eqn{t_R}. Here, \eqn{i(t)} describes the
impurity of a node \eqn{t}, \eqn{p(t)} the proportion of data points falling
into \eqn{t}, and \eqn{p(t' | t)} the proportion of data points falling
from \eqn{t} into \eqn{t'}.
Since the regression models are fitted using maximum likelihood, the
maximum likelihood criterion fulfills this property and can also be seen as
an extension of the entropy impurity criterion in the case of classification
or an extension of the MSE impurity criterion in the case of regression.

The default model selection is done by choosing the most parsimonious model
that yields a cross-validation error in the range of
\eqn{\mathrm{CV}_{\min} + \mathrm{SE}_{\min}}
for the minimal cross-validation error \eqn{\mathrm{CV}_{\min}} and its
corresponding standard error \eqn{\mathrm{SE}_{\min}}.
For a more robust standard error estimation, the scores are calculated per
training observation such that the AUC is no longer an appropriate choice
and the deviance or the Brier score should be used in the case of
classification.
}
\references{
\itemize{
  \item Breiman, L., Friedman, J., Stone, C. J. & Olshen, R. A. (1984).
  Classification and Regression Trees. CRC Press.
  \doi{https://doi.org/10.1201/9781315139470}
}
}
