% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelInputs.R
\name{recodeData}
\alias{recodeData}
\title{Recode a data frame to create dummy-coded categorical and interaction
variables.}
\usage{
recodeData(data, parNames, randPars)
}
\arguments{
\item{data}{The choice data, formatted as a \code{data.frame} object.}

\item{parNames}{The names of the parameters to be estimated in the model.
Must be the same as the column names in the \code{data} argument. For WTP space
models, do not include price in \code{parNames}.}

\item{randPars}{A named vector whose names are the random parameters and
values the distribution: \code{'n'} for normal or \code{'ln'} for log-normal.
Defaults to \code{NULL}.}
}
\value{
A list of a dataframe (\code{data}) and two vectors (\code{parNames} and
\code{randPars}) with discrete (categorical) variables and interaction variables
added.
}
\description{
Recodes a list of a dataframe (\code{data}) and two vectors (\code{parNames} and
\code{randPars}) with discrete (categorical) variables and interaction variables
added to the data frame as well as the \code{parNames} and \code{randPars}. This
function is used internally inside the main \code{logitr()} function but is also
exported for use in other libraries.
}
\examples{
data(yogurt)

result <- recodeData(
    data = yogurt,
    parNames = c("price", "feat", "brand", "price*brand"),
    randPars = c(feat = "n", brand = "n")
)

result$parNames
result$randPars
head(result$data)
}
