% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/print.R
\name{print.loo}
\alias{plot.loo}
\alias{print.compare.loo}
\alias{print.loo}
\title{Print and plot methods}
\usage{
\method{print}{loo}(x, ..., digits = 1, warn = TRUE, plot_k = FALSE)

\method{print}{compare.loo}(x, ..., digits = 1)

\method{plot}{loo}(x, ..., label_points = FALSE)
}
\arguments{
\item{x}{A list with class \code{'loo'} (as returned by the \code{\link{loo}}
function or, for \code{print} only, the \code{\link{waic}} function). For
\code{print}, \code{x} can also have class \code{'compare.loo'} (as
returned by \code{\link{compare}}).}

\item{...}{Ignored for \code{print}. For \code{plot} you can use \code{...}
to pass arguments to \code{\link[graphics]{text}} if \code{label_points =
TRUE}.}

\item{digits}{Passed to \code{\link[base]{round}}.}

\item{warn}{Logical. If \code{TRUE} (the default), a warning message will be
printed if any estimates for the Pareto shape parameter \eqn{k} are
problematic. See section PSIS-LOO in \code{\link{loo-package}}. Ignored if
\code{x} was generated by \code{\link{waic}}.}

\item{plot_k}{Logical. If \code{TRUE} the estimates of \eqn{k} are plotted.
Ignored if \code{x} was generated by \code{\link{waic}}. To just plot
\eqn{k} without printing use \code{plot(x)}.}

\item{label_points}{Logical. If \code{TRUE} the observation numbers
  corresponding to any values of \eqn{k} greater than 0.5 will be displayed
  in the plot. Any arguments specified in \code{...} will be passed to
  \code{\link[graphics]{text}} and can be used to control the appearance of
  the labels.}
}
\value{
The print methods return \code{x} invisibly.
}
\description{
Print and plot methods
}

