% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer.R
\name{l_layer_polygon}
\alias{l_layer_polygon}
\title{Layer a polygon}
\usage{
l_layer_polygon(widget, x, y, color = "gray80", linecolor = "black",
  linewidth = 1, label = "polygon", parent = "root", index = 0, ...)
}
\arguments{
\item{widget}{widget path name as a string}

\item{x}{x coordinates}

\item{y}{y coordinates}

\item{color}{fill color, if empty string \code{""}, then the fill is transparant}

\item{linecolor}{outline color}

\item{linewidth}{linewidth of outline}

\item{label}{label used in the layers inspector}

\item{parent}{group layer}

\item{index}{of the newly added layer in its parent group}

\item{...}{additional state initialization arguments, see 
\code{\link{l_info_states}}}
}
\value{
layer object handle, layer id
}
\description{
Loon's displays that are based on Cartesian coordinates (i.e.
  scatterplot, histogram and graph display) allow for layering visual
  information including polygons, text and rectangles.
}
\details{
For more information run: \code{l_help("learn_R_layer")}
}
\examples{
set.seed(500)
x <- rnorm(30)
y <- 4 + 3*x + rnorm(30)
fit <- lm(y~x)
xseq <- seq(min(x)-1, max(x)+1, length.out = 50)
fit_line <- predict(fit, data.frame(x=range(xseq)))
ci <- predict(fit, data.frame(x=xseq), 
              interval="confidence", level=0.95)
pi <- predict(fit, data.frame(x=xseq),
              interval="prediction", level=0.95)


p <- l_plot(y~x, color='black', showScales=TRUE, showGuides=TRUE)
gLayer <- l_layer_group(
    p, label="simple linear regression",
    parent="root", index="end"
)
fitLayer <- l_layer_line(
    p, x=range(xseq), y=fit_line, color="#04327F",
    linewidth=4, label="fit", parent=gLayer
)
ciLayer <- l_layer_polygon(
    p,
    x = c(xseq, rev(xseq)), 
    y = c(ci[,'lwr'], rev(ci[,'upr'])),
    color = "#96BDFF", linecolor="",
    label = "95 \% confidence interval",
    parent = gLayer, index='end'
)
piLayer <- l_layer_polygon(
    p,
    x = c(xseq, rev(xseq)), 
    y = c(pi[,'lwr'], rev(pi[,'upr'])),
    color = "#E2EDFF", linecolor="",
    label = "95 \% prediction interval",
    parent = gLayer, index='end'
)

l_info_states(piLayer)
}
\seealso{
\code{\link{l_layer}}, \code{\link{l_info_states}}
}
