% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_loonWidgets.R
\name{l_loonWidgets}
\alias{l_loonWidgets}
\title{Get all active top level loon plots.}
\usage{
l_loonWidgets(pathTypes, inspector = FALSE)
}
\arguments{
\item{pathTypes}{an optional argument identifying the collection of path types that
are to be returned (if displayed).}

\item{inspector}{whether to return the loon inspector widget or not

This must be a subset of the union of
\code{\link{l_basePaths}()} and \code{\link{l_compoundPaths}()}.

If it is missing,
all \code{\link{l_basePaths}()} and \code{\link{l_compoundPaths}()} will be returned.}
}
\value{
list whose elements are named by, and contain the values of, the
loon plot widgets.  The list can be nested when loon plots (like \code{\link{l_pairs}})
are compound in that they consist of more than one base loon plot.
}
\description{
Loon's plots are constructed in TCL and identified with
a path string appearing in the window containing the plot.

If the plots were not saved on a variable, this function will
look for all loon plots displayed and return their values in a list whose
elements may then be assigned to R variables.
}
\examples{
if(interactive()){
l_plot(iris)
l_hist(iris)
l_hist(mtcars)
l_pairs(iris)
# The following will not be loonWidgets (neither is the inspector)
tt <- tktoplevel()
tkpack(l1 <- tklabel(tt, text = "Heave"), l2<- tklabel(tt, text = "Ho"))
#
# This will return loon widgets corresponding to plots
loonPlots <- l_loonWidgets()
names(loonPlots)
firstPlot <- loonPlots[[1]]
firstPlot["color"] <- "red"
histograms <- l_loonWidgets("hist")
lapply(histograms,
       FUN  = function(hist) {
                hist["binwidth"] <- hist["binwidth"]/2
                l_scaleto_world(hist)
             }
             )
}

}
\seealso{
\code{\link{l_basePaths}}\code{\link{l_compoundPaths}} \code{\link{l_getFromPath}}
}
