% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.expression.R
\name{lotriDataFrameToLotriExpression}
\alias{lotriDataFrameToLotriExpression}
\title{Convert a lotri data frame to a lotri expression}
\usage{
lotriDataFrameToLotriExpression(data, useIni = FALSE)
}
\arguments{
\item{data}{lotri data frame}

\item{useIni}{Use `ini` instead of `lotri` in the expression}
}
\value{
expression of the lotri syntax equivalent to the data.frame provided
}
\description{
Convert a lotri data frame to a lotri expression
}
\examples{

 x <- lotri({
  tka <- 0.45; label("Log Ka")
  tcl <- 1; label("Log Cl")
  tv <- 3.45; label("Log V")
  eta.ka ~ 0.6
  eta.cl ~ 0.3
  eta.v ~ 0.1
  add.err <- 0.7
})

df <- as.data.frame(x)

lotriDataFrameToLotriExpression(df)

# You may also call as.expression directly from the lotri object

as.expression(x)

}
\author{
Matthew L. Fidler
}
