% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lotri.R
\name{lotri}
\alias{lotri}
\title{Easily Specify block-diagonal matrices with lower triangular info}
\usage{
lotri(x, ..., envir = parent.frame(), default = "id")
}
\arguments{
\item{x}{list, matrix or expression, see details}

\item{...}{Other arguments treated as a list that will be
concatenated then reapplied to this function.}

\item{envir}{the \code{\link[base]{environment}} in which \code{expr} is to
    be evaluated.  May also be \code{NULL}, a list, a data frame,
    a pairlist or an integer as specified to \code{\link[base]{sys.call}}.}

\item{default}{Is the default factor when no conditioning is
implemented.}
}
\value{
named symmetric matrix useful in `rxode2()` simulations (and
    perhaps elsewhere)
}
\description{
Easily Specify block-diagonal matrices with lower triangular info
}
\details{
This can take an R matrix, a list including matrices or
 expressions, or expressions

 Expressions can take the form

 name ~ estimate

 Or the lower triangular matrix when "adding" the names

 name1 + name2 ~ c(est1,
                   est2, est3)

 The matrices are concatenated into a block diagonal matrix, like
 \code{\link[Matrix]{bdiag}}, but allows expressions to specify
 matrices easier.
}
\examples{

## A few ways to specify the same matrix
lotri({et2 + et3 + et4 ~ c(40,
                           0.1, 20,
                           0.1, 0.1, 30)})

## You  do not need to enclose in {}
lotri(et2 + et3 + et4 ~ c(40,
                          0.1, 20,
                          0.1, 0.1, 30),
          et5 ~ 6)
## But if you do enclose in {}, you can use
## multi-line matrix specifications:

lotri({et2 + et3 + et4 ~ c(40,
                           0.1, 20,
                           0.1, 0.1, 30)
          et5 ~ 6
          })

## You can also add lists or actual R matrices as in this example:
lotri(list(et2 + et3 + et4 ~ c(40,
                               0.1, 20,
                               0.1, 0.1, 30),
              matrix(1,dimnames=list("et5","et5"))))

## Overall this is a flexible way to specify symmetric block
## diagonal matrices.

## For rxode2, you may also condition based on different levels of
## nesting with lotri;  Here is an example:

mat <- lotri(lotri(iov.Ka ~ 0.5,
                    iov.Cl ~ 0.6),
              lotri(occ.Ka ~ 0.5,
                    occ.Cl ~ 0.6) | occ(lower=4,nu=3))

mat

## you may access features of the matrix simply by `$` that is

mat$lower # Shows the lower bound for each condition

mat$lower$occ # shows the lower bound for the occasion variable

## Note that `lower` fills in defaults for parameters.  This is true
## for `upper` true;  In fact when accessing this the defaults
## are put into the list

mat$upper

## However all other values return NULL if they are not present like

mat$lotri

## And values that are specified once are only returned on one list:

mat$nu

mat$nu$occ
mat$nu$id

## You can also change the default condition with `as.lotri`

mat <- as.lotri(mat, default="id")

mat

}
\author{
Matthew L Fidler
}
