# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @name find_lag_c
#' @title Compute optimal lag length
#' @description Determine optimal lag length based on 'AICc', 'AIC', or 'BIC' criterion.
#'
#' @param y List with left (endogenous) variables
#' @param x List with right (exogenous) variables
#' @param lag_crit Integer: 'AICc'= 1, 'AIC' = 2, 'BIC' = 3.
NULL

find_lag_c <- function(y, x, lag_crit, h, k, max_lags) {
    .Call(`_lpirfs_find_lag_c`, y, x, lag_crit, h, k, max_lags)
}

#' @name newey_west_c
#' @title Compute OLS parameters and robust standard errors based on Newey-West estimator
#' @description  Compute OLS parameters and robust standard errors based on Newey and West (1987).
#' The function is based on the Matlab code by James P. LeSage.
#' @param y Numeric vector
#' @param x Numeric matrix
#' @param h Integer
#' @references
#' Newey W.K., and West K.D. (1987). “A Simple, Positive-Definite, Heteroskedasticity and
#' Autocorrelation Consistent Covariance Matrix.” \emph{Econometrica}, 55, 703–708.
newey_west_c <- function(y, x, h) {
    .Call(`_lpirfs_newey_west_c`, y, x, h)
}

