% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{natrisk}
\alias{natrisk}
\title{Number of subjects at risk}
\usage{
natrisk(
  time = NA_real_,
  allocationRatioPlanned = 1,
  accrualTime = 0L,
  accrualIntensity = NA_real_,
  piecewiseSurvivalTime = 0L,
  lambda1 = NA_real_,
  lambda2 = NA_real_,
  gamma1 = 0L,
  gamma2 = 0L,
  accrualDuration = NA_real_,
  minFollowupTime = NA_real_,
  maxFollowupTime = NA_real_
)
}
\arguments{
\item{time}{Analysis times at which to calculate the number of patients at
risk.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{accrualTime}{Accrual time intervals, must start with 0, e.g.,
c(0, 3) breaks the time axis into 2 accrual intervals: [0, 3), [3, Inf).
Defaults to 0 for uniform accrual.}

\item{accrualIntensity}{A vector of accrual intensities, one for
each accrual time interval.}

\item{piecewiseSurvivalTime}{A vector that specifies the time intervals for
the piecewise exponential survival distribution, must start with 0, e.g.,
c(0, 6) breaks the time axis into 2 event intervals: [0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{lambda1}{A vector of hazard rates for the event for the
active treatment group, one for each analysis time interval.}

\item{lambda2}{A vector of hazard rates for the event for the
control group, one for each analysis time interval.}

\item{gamma1}{The hazard rate for exponential dropout or a vector of hazard
rates for piecewise exponential dropout for the active treatment group.
Defaults to 0 for no dropout.}

\item{gamma2}{The hazard rate for exponential dropout or a vector of hazard
rates for piecewise exponential dropout for the control group.
Defaults to 0 for no dropout.}

\item{accrualDuration}{Duration of the enrollment period.}

\item{minFollowupTime}{Follow-up time for the last enrolled subject.}

\item{maxFollowupTime}{Follow-up time for the first enrolled subject.
For fixed followup, maxFollowupTime = minFollowupTime.
For variable followup, maxFollowupTime = accrualDuration + minFollowupTime.}
}
\value{
A matrix of the number of patients at risk at the specified
analysis times for each treatment group.
}
\description{
Obtains the number of subjects at risk at a given analysis
time across two treatment groups.
}
\examples{
# Piecewise accrual time and intensity, piecewise exponential survivals,
# and 5\% dropout by the end of 1 year.
natrisk(time = c(9, 24), allocationRatioPlanned = 1, accrualTime = c(0, 3),
        accrualIntensity = c(10, 20), piecewiseSurvivalTime = c(0, 6),
        lambda1 = c(0.0533, 0.0309), lambda2 = c(0.0533, 0.0533),
        gamma1 = -log(1-0.05)/12, gamma2 = -log(1-0.05)/12,
        accrualDuration = 12, minFollowupTime = 18, maxFollowupTime = 30)

}
\keyword{internal}
