% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{exitprob}
\alias{exitprob}
\title{Stagewise exit probabilities}
\usage{
exitprob(b, a = NA, theta = 0, I = NA)
}
\arguments{
\item{b}{Upper boundaries on the z-test statistic scale.}

\item{a}{Lower boundaries on the z-test statistic scale. Defaults to
\code{c(rep(-6.0, kMax-1), b[kMax])} if left unspecified, where
\code{kMax = length(b)}.}

\item{theta}{Stagewise parameter of interest, e.g., \code{-U/V} for
weighted log-rank test, where \code{U} is the mean and \code{V} is
the variance of the weighted log-rank test score statistic at each stage.
For proportional hazards and conventional log-rank test, use the
scalar input, \code{theta = -log(HR)}. Defaults to 0 corresponding to 
the null hypothesis.}

\item{I}{Stagewise cumulative information, e.g., \code{V}, the variance
of the weighted log-rank test score statistic at each stage. For
conventional log-rank test, information can be approximated by
\code{phi*(1-phi)*D}, where \code{phi} is the probability of being
allocated to the active arm, and \code{D} is the total number of events 
at each stage. Defaults to \code{seq(1, kMax)} if left unspecified.}
}
\value{
A list of stagewise exit probabilities: one vector for efficacy
stopping probabilities, and the other vector for futility stopping
probabilities.
}
\description{
Obtains the stagewise exit probabilities for both efficacy and
futility stopping.
}
\examples{
exitprob(b = c(3.471, 2.454, 2.004), theta = -log(0.6), 
         I = c(50, 100, 150)/4)
         
exitprob(b = c(2.963, 2.359, 2.014), 
         a = c(-0.264, 0.599, 2.014), 
         theta = c(0.141, 0.204, 0.289), 
         I = c(81, 121, 160))

}
