% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{fstp2seq}
\alias{fstp2seq}
\title{Adjusted p-values for stepwise testing procedures for two sequences}
\usage{
fstp2seq(p, gamma, test = "hochberg", retest = TRUE)
}
\arguments{
\item{p}{The raw p-values for elementary hypotheses.}

\item{gamma}{The truncation parameters for each family.}

\item{test}{The component multiple testing procedure. It is either "Holm"
or "Hochberg", and it defaults to "Hochberg".}

\item{retest}{Whether to allow retesting. It defaults to TRUE.}
}
\value{
A matrix of adjusted p-values.
}
\description{
Obtains the adjusted p-values for the stepwise gatekeeping
procedures for multiplicity problems involving two sequences of hypotheses.
}
\examples{

p = c(0.0194, 0.0068, 0.0271, 0.0088, 0.0370, 0.0018, 0.0814, 0.0066)
gamma = c(0.6, 0.6, 0.6, 1)
fstp2seq(p, gamma, test="hochberg", retest=1)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
