% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{samplesizeRiskRatioExact}
\alias{samplesizeRiskRatioExact}
\title{Sample Size for Exact Unconditional Test of Risk Ratio}
\usage{
samplesizeRiskRatioExact(
  beta = NA_real_,
  riskRatioH0 = 1,
  pi1 = NA_real_,
  pi2 = NA_real_,
  allocationRatioPlanned = 1,
  alpha = 0.025
)
}
\arguments{
\item{beta}{The type II error.}

\item{riskRatioH0}{The risk ratio under the null hypothesis.
Defaults to 1.}

\item{pi1}{The assumed probability for the active treatment group.}

\item{pi2}{The assumed probability for the control group.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{alpha}{The one-sided significance level.}
}
\value{
A data frame with the following variables:
\itemize{
\item \code{alpha}: The specified one-sided significance level.
\item \code{attainedAlpha}: The attained one-sided significance level.
\item \code{power}: The power.
\item \code{n}: The sample size.
\item \code{riskRatioH0}: The risk ratio under the null hypothesis.
\item \code{pi1}: The assumed probability for the active treatment group.
\item \code{pi2}: The assumed probability for the control group.
\item \code{allocationRatioPlanned}: Allocation ratio for the active
treatment versus control.
\item \code{zstatRiskRatioBound}: The critical value on the scale of
score test statistic for risk ratio.
\item \code{pi2star}: The response probability in the control group
at which the critical value of the test statistic is attained.
}
}
\description{
Obtains the sample size given power for exact unconditional
test of risk ratio.
}
\examples{

samplesizeRiskRatioExact(beta = 0.2, riskRatioH0 = 0.8,
                         pi1 = 0.95, pi2 = 0.95, alpha = 0.05)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
\keyword{internal}
