% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDesignProportions.R
\name{ClopperPearsonCI}
\alias{ClopperPearsonCI}
\title{Clopper-Pearson Confidence Interval for One-Sample Proportion}
\usage{
ClopperPearsonCI(n, y, cilevel = 0.95)
}
\arguments{
\item{n}{The sample size.}

\item{y}{The number of responses.}

\item{cilevel}{The confidence interval level.}
}
\value{
A data frame with the following variables:
\itemize{
\item \code{n}: The sample size.
\item \code{y}: The number of responses.
\item \code{phat}: The observed proportion of responses.
\item \code{lower}: The lower limit of the confidence interval.
\item \code{upper}: The upper limit of the confidence interval.
\item \code{cilevel}: The confidence interval level.
}
}
\description{
Obtains the Clopper-Pearson exact confidence interval for
a one-sample proportion.
}
\examples{

ClopperPearsonCI(20, 3)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
