% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{kmest}
\alias{kmest}
\title{Stratified difference in milestone survival}
\usage{
kmest(
  time = NA_real_,
  milestone = NA_real_,
  allocationRatioPlanned = 1,
  accrualTime = 0L,
  accrualIntensity = NA_real_,
  piecewiseSurvivalTime = 0L,
  stratumFraction = 1L,
  lambda1 = NA_real_,
  lambda2 = NA_real_,
  gamma1 = 0L,
  gamma2 = 0L,
  accrualDuration = NA_real_,
  followupTime = NA_real_,
  fixedFollowup = 0L,
  numSubintervals = 300L
)
}
\arguments{
\item{time}{A vector of calendar times at which to calculate the
milestone survival.}

\item{milestone}{The milestone time at which to calculate the
Kaplan-Meier estimate of survival probability.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{accrualTime}{A vector that specifies the starting time of
piecewise Poisson enrollment time intervals. Must start with 0, e.g.,
\code{c(0, 3)} breaks the time axis into 2 accrual intervals:
[0, 3) and [3, Inf).}

\item{accrualIntensity}{A vector of accrual intensities. One for
each accrual time interval.}

\item{piecewiseSurvivalTime}{A vector that specifies the starting time of
piecewise exponential survival time intervals. Must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{stratumFraction}{A vector of stratum fractions that sum to 1.
Defaults to 1 for no stratification.}

\item{lambda1}{A vector of hazard rates for the event in each analysis
time interval by stratum for the active treatment group.}

\item{lambda2}{A vector of hazard rates for the event in each analysis
time interval by stratum for the control group.}

\item{gamma1}{The hazard rate for exponential dropout, a vector of hazard
rates for piecewise exponential dropout applicable for all strata, or a
vector of hazard rates for dropout in each analysis time interval
by stratum for the active treatment group.}

\item{gamma2}{The hazard rate for exponential dropout, a vector of hazard
rates for piecewise exponential dropout applicable for all strata, or a
vector of hazard rates for dropout in each analysis time interval
by stratum for the control group.}

\item{accrualDuration}{Duration of the enrollment period.}

\item{followupTime}{Follow-up time for the last enrolled subject.}

\item{fixedFollowup}{Whether a fixed follow-up design is used.
Defaults to 0 for variable follow-up.}

\item{numSubintervals}{Number of sub-intervals to approximate the mean
and variance of the weighted log-rank test score statistic.
Defaults to 300. Specify a larger number for better approximation.}
}
\value{
A data frame containing the following variables:
\itemize{
\item \code{time}: The calendar time at which to calculate the milestone
survival.
\item \code{subjects}: The enrolled number of subjects.
\item \code{milestone}: The milestone time relative to randomization.
\item \code{surv1}: The milestone survival probability for the treatment
group.
\item \code{surv2}: The milestone survival probability for the control group.
\item \code{vsurv1}: The variance for \code{surv1}.
\item \code{vsurv2}: The variance for \code{surv2}.
\item \code{survdiff}: The difference in milestone survival probabilities,
i.e., \code{surv1 - surv2}.
\item \code{vsurvdiff}: The variance for \code{survdiff}.
\item \code{survdiffZ}: The Z-statistic value, i.e.,
\code{survdiff/sqrt(vsurvdiff)}.
}
}
\description{
Obtains the stratified Kaplan-Meier estimate of
milestone survival probabilities and difference in milestone
survival at given calendar times and milestone time.
}
\examples{
# Piecewise accrual, piecewise exponential survivals, and 5\% dropout by
# the end of 1 year.

kmest(time = c(22, 40),
      milestone = 18,
      allocationRatioPlanned = 1,
      accrualTime = seq(0, 8),
      accrualIntensity = 26/9*seq(1, 9),
      piecewiseSurvivalTime = c(0, 6),
      stratumFraction = c(0.2, 0.8),
      lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
      lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
      gamma1 = -log(1-0.05)/12,
      gamma2 = -log(1-0.05)/12,
      accrualDuration = 22,
      followupTime = 18, fixedFollowup = FALSE)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
