% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{nbpowerequiv}
\alias{nbpowerequiv}
\title{Power for equivalence in negative binomial rate ratio}
\usage{
nbpowerequiv(
  kMax = 1L,
  informationRates = NA_real_,
  criticalValues = NA_real_,
  alpha = 0.05,
  typeAlphaSpending = "sfOF",
  parameterAlphaSpending = NA_real_,
  userAlphaSpending = NA_real_,
  rateRatioLower = NA_real_,
  rateRatioUpper = NA_real_,
  allocationRatioPlanned = 1,
  accrualTime = 0L,
  accrualIntensity = 1500L,
  piecewiseSurvivalTime = 0L,
  kappa1 = 5,
  kappa2 = 5,
  lambda1 = 0.125,
  lambda2 = 0.125,
  gamma1 = 0L,
  gamma2 = 0L,
  accrualDuration = 1.25,
  followupTime = 2.75,
  fixedFollowup = 0L,
  spendingTime = NA_real_,
  studyDuration = NA_real_,
  nullVariance = 0L
)
}
\arguments{
\item{kMax}{The maximum number of stages.}

\item{informationRates}{The information rates.
Defaults to \code{(1:kMax) / kMax} if left unspecified.}

\item{criticalValues}{Upper boundaries on the z-test statistic scale
for stopping for efficacy.}

\item{alpha}{The significance level for each of the two one-sided
tests. Defaults to 0.05.}

\item{typeAlphaSpending}{The type of alpha spending. One of the following:
"OF" for O'Brien-Fleming boundaries, "P" for Pocock boundaries,
"WT" for Wang & Tsiatis boundaries, "sfOF" for O'Brien-Fleming type
spending function, "sfP" for Pocock type spending function,
"sfKD" for Kim & DeMets spending function, "sfHSD" for Hwang,
Shi & DeCani spending function, "user" for user defined spending,
and "none" for no early efficacy stopping. Defaults to "sfOF".}

\item{parameterAlphaSpending}{The parameter value for the alpha spending.
Corresponds to Delta for "WT", rho for "sfKD", and gamma for "sfHSD".}

\item{userAlphaSpending}{The user defined alpha spending. Cumulative alpha
spent up to each stage.}

\item{rateRatioLower}{The lower equivalence limit of rate ratio.}

\item{rateRatioUpper}{The upper equivalence limit of rate ratio.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{accrualTime}{A vector that specifies the starting time of
piecewise Poisson enrollment time intervals. Must start with 0, e.g.,
\code{c(0, 3)} breaks the time axis into 2 accrual intervals:
[0, 3) and [3, Inf).}

\item{accrualIntensity}{A vector of accrual intensities. One for
each accrual time interval.}

\item{piecewiseSurvivalTime}{A vector that specifies the starting time of
piecewise exponential survival time intervals. Must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{kappa1}{The dispersion parameter (reciprocal of the shape parameter
of the gamma mixing distribution) for the active treatment group.}

\item{kappa2}{The dispersion parameter (reciprocal of the shape parameter
of the gamma mixing distribution) for the control group.}

\item{lambda1}{The rate parameter of the negative binomial distribution
for the active treatment group.}

\item{lambda2}{The rate parameter of the negative binomial distribution
for the control group.}

\item{gamma1}{The hazard rate for exponential dropout, or a vector of
hazard rates for piecewise exponential dropout for the active
treatment group. Defaults to 0 for no dropout.}

\item{gamma2}{The hazard rate for exponential dropout, or a vector of
hazard rates for piecewise exponential dropout for the control group.
Defaults to 0 for no dropout.}

\item{accrualDuration}{Duration of the enrollment period.}

\item{followupTime}{Follow-up time for the last enrolled subject.}

\item{fixedFollowup}{Whether a fixed follow-up design is used.
Defaults to 0 for variable follow-up.}

\item{spendingTime}{A vector of length \code{kMax} for the error spending
time at each analysis. Defaults to missing, in which case, it is the
same as \code{informationRates}.}

\item{studyDuration}{Study duration for fixed follow-up design.
Defaults to missing, which is to be replaced with the sum of
\code{accrualDuration} and \code{followupTime}. If provided,
the value is allowed to be less than the sum of \code{accrualDuration}
and \code{followupTime}.}

\item{nullVariance}{Whether to calculate the variance for log rate ratio
under the null hypothesis.}
}
\value{
An S3 class \code{nbpowerequiv} object with 4 components:
\itemize{
\item \code{overallResults}: A data frame containing the following variables:
\itemize{
\item \code{overallReject}: The overall rejection probability.
\item \code{alpha}: The overall significance level.
\item \code{attainedAlphaH10}: The attained significance level under H10.
\item \code{attainedAlphaH20}: The attained significance level under H20.
\item \code{numberOfEvents}: The total number of events.
\item \code{numberOfDropouts}: The total number of dropouts.
\item \code{numbeOfSubjects}: The total number of subjects.
\item \code{exposure}: The total exposure.
\item \code{studyDuration}: The total study duration.
\item \code{information}: The maximum information.
\item \code{expectedNumberOfEvents}: The expected number of events.
\item \code{expectedNumberOfDropouts}: The expected number of dropouts.
\item \code{expectedNumberOfSubjects}: The expected number of subjects.
\item \code{expectedExposure}: The expected exposure.
\item \code{expectedStudyDuration}: The expected study duration.
\item \code{expectedInformation}: The expected information.
\item \code{kMax}: The number of stages.
\item \code{rateRatioLower}: The lower equivalence limit of rate ratio.
\item \code{rateRatioUpper}: The upper equivalence limit of rate ratio.
\item \code{rateRatio}: The rate ratio.
}
\item \code{byStageResults}: A data frame containing the following variables:
\itemize{
\item \code{informationRates}: The information rates.
\item \code{efficacyBounds}: The efficacy boundaries on the Z-scale for
each of the two one-sided tests.
\item \code{rejectPerStage}: The probability for efficacy stopping.
\item \code{cumulativeRejection}: The cumulative probability for efficacy
stopping.
\item \code{cumulativeAlphaSpent}: The cumulative alpha for each of
the two one-sided tests.
\item \code{cumulativeAttainedAlphaH10}: The cumulative alpha attained
under \code{H10}.
\item \code{cumulativeAttainedAlphaH20}: The cumulative alpha attained
under \code{H20}.
\item \code{numberOfEvents}: The number of events.
\item \code{numberOfDropouts}: The number of dropouts.
\item \code{numberOfSubjects}: The number of subjects.
\item \code{exposure}: The exposure.
\item \code{analysisTime}: The average time since trial start.
\item \code{efficacyRateRatioLower}: The efficacy boundaries on the
rate ratio scale for the one-sided null hypothesis at the
lower equivalence limit.
\item \code{efficacyRateRatioUpper}: The efficacy boundaries on the
rate ratio scale for the one-sided null hypothesis at the
upper equivalence limit.
\item \code{efficacyP}: The efficacy bounds on the p-value scale for
each of the two one-sided tests.
\item \code{information}: The cumulative information.
}
\item \code{settings}: A list containing the following input parameters:
\code{typeAlphaSpending}, \code{parameterAlphaSpending},
\code{userAlphaSpending}, \code{allocationRatioPlanned},
\code{accrualTime}, \code{accuralIntensity},
\code{piecewiseSurvivalTime}, \code{kappa1}, \code{kappa2},
\code{lambda1}, \code{lambda2}, \code{gamma1}, \code{gamma2},
\code{accrualDuration}, \code{followupTime}, \code{fixedFollowup},
\code{spendingTime}, \code{nullVariance}, and \code{varianceRatios}.
The \code{varianceRatios} is a data frame with the following
variables:
\itemize{
\item \code{varianceRatioH10}: The ratio of the variance under
\code{H10} to the variance under \code{H1}.
\item \code{varianceRatioH20}: The ratio of the variance under
\code{H20} to the variance under \code{H1}.
\item \code{varianceRatioH12}: The ratio of the variance under
\code{H10} to the variance under \code{H20}.
\item \code{varianceRatioH21}: The ratio of the variance under
\code{H20} to the variance under \code{H10}.//'
}
\item \code{byTreatmentCounts}: A list containing the following counts by
treatment group:
\itemize{
\item \code{numberOfEvents1}: The number of events by stage for
the treatment group.
\item \code{numberOfDropouts1}: The number of dropouts by stage for
the treatment group.
\item \code{numberOfSubjects1}: The number of subjects by stage for
the treatment group.
\item \code{exposure1}: The exposure by stage for the treatment group.
\item \code{numberOfEvents2}: The number of events by stage for
the control group.
\item \code{numberOfDropouts2}: The number of dropouts by stage for
the control group.
\item \code{numberOfSubjects2}: The number of subjects by stage for
the control group.
\item \code{exposure2}: The exposure by stage for the control group.
\item \code{expectedNumberOfEvents1}: The expected number of events for
the treatment group.
\item \code{expectedNumberOfDropouts1}: The expected number of dropouts
for the treatment group.
\item \code{expectedNumberOfSubjects1}: The expected number of subjects
for the treatment group.
\item \code{expectedExposure1}: The expected exposure for the treatment
group.
\item \code{expectedNumberOfEvents2}: The expected number of events for
control group.
\item \code{expectedNumberOfDropouts2}: The expected number of dropouts
for the control group.
\item \code{expectedNumberOfSubjects2}: The expected number of subjects
for the control group.
\item \code{expectedExposure2}: The expected exposure for the control
group.
}
}
}
\description{
Obtains the power for equivalence in negative binomial
rate ratio.
}
\examples{

# Example 1: Variable follow-up design
nbpowerequiv(kMax = 2, informationRates = c(0.5, 1),
             alpha = 0.05, typeAlphaSpending = "sfOF",
             rateRatioLower = 2/3, rateRatioUpper = 3/2,
             accrualIntensity = 1956/1.25,
             kappa1 = 5, kappa2 = 5,
             lambda1 = 0.125, lambda2 = 0.125,
             gamma1 = 0, gamma2 = 0,
             accrualDuration = 1.25,
             followupTime = 2.75, fixedFollowup = FALSE,
             nullVariance = 1)

# Example 2: Fixed follow-up design
nbpowerequiv(kMax = 2, informationRates = c(0.5, 1),
             alpha = 0.05, typeAlphaSpending = "sfOF",
             rateRatioLower = 0.5, rateRatioUpper = 2,
             accrualIntensity = 220/1.5,
             kappa1 = 3, kappa2 = 3,
             lambda1 = 8.4, lambda2 = 8.4,
             gamma1 = 0, gamma2 = 0,
             accrualDuration = 1.5,
             followupTime = 0.5, fixedFollowup = TRUE)

}
\seealso{
\code{\link{nbstat}}
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
