% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDesignProportions.R
\name{getDesignFisherExact}
\alias{getDesignFisherExact}
\title{Power and sample size for Fisher's exact test for two proportions}
\usage{
getDesignFisherExact(
  beta = NA_real_,
  n = NA_real_,
  pi1 = NA_real_,
  pi2 = NA_real_,
  allocationRatioPlanned = 1,
  alpha = 0.05
)
}
\arguments{
\item{beta}{The type II error.}

\item{n}{The total sample size.}

\item{pi1}{The assumed probability for the active treatment group.}

\item{pi2}{The assumed probability for the control group.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{alpha}{The two-sided significance level. Defaults to 0.05.}
}
\value{
A data frame with the following variables:
\itemize{
\item \code{alpha}: The two-sided significance level.
\item \code{power}: The power.
\item \code{n}: The sample size.
\item \code{pi1}: The assumed probability for the active treatment group.
\item \code{pi2}: The assumed probability for the control group.
\item \code{allocationRatioPlanned}: Allocation ratio for the active
treatment versus control.
}
}
\description{
Obtains the power given sample size or obtains the sample
size given power for Fisher's exact test for two proportions.
}
\examples{

(design1 <- getDesignFisherExact(
  beta = 0.2, pi1 = 0.5, pi2 = 0.2, alpha = 0.05))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
