% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{phregr}
\alias{phregr}
\title{Proportional hazards regression model}
\usage{
phregr(
  data,
  rep = "rep",
  stratum = "stratum",
  time = "time",
  time2 = "time2",
  event = "event",
  covariates = "treat",
  weight = "weight",
  id = "id",
  ties = "efron",
  robust = 0L
)
}
\arguments{
\item{data}{The input data frame that contains the following variables:
\itemize{
\item \code{rep}: The replication for by-group processing.
\item \code{stratum}: The stratum.
\item \code{time}: The follow-up time for right censored data, or
the left end of each interval for counting process data.
\item \code{time2}: The right end of each interval for counting process
data only. Intervals are assumed to be open on the left
and closed on the right, and event indicates whether an event
occurred at the right end of each interval.
\item \code{event}: The event indicator, normally 1=event, 0=no event.
\item \code{covariates}: The values of baseline covariates (and
time-dependent covariates in each interval for counting
process data). This is the full-rank design matrix for the Cox
model, assuming that factor variables have already been
expanded into dummy variables.
\item \code{weight}: The weight for each observation.
\item \code{id}: The optional subject ID for counting process data
with time-dependent covariates.
}}

\item{rep}{The name of the replication variable in the input data.}

\item{stratum}{The name of the stratum variable in the input data.}

\item{time}{The name of the time variable or the left end of each
interval for counting process data in the input data.}

\item{time2}{The name of the right end of each interval for counting
process data in the input data.}

\item{event}{The name of the event variable in the input data.}

\item{covariates}{The vector of names of baseline and time-dependent
covariates in the input data.}

\item{weight}{The name of the weighting variable in the input data.}

\item{id}{The name of the id variable in the input data.}

\item{ties}{The method for handling ties with options including
"breslow" and "efron" (default).}

\item{robust}{Whether a robust sandwich variance estimate should be
computed. The default is TRUE if there are fractional weights or
there is at least 1 id with >1 event. In the presence of the id
variable, the score residual will be aggregated for each id when
computing the robust sandwich variance estimate.}
}
\value{
A list with the following components:
\itemize{
\item \code{sumstat}: The data frame of summary statistics of model fit
with the following variables:
\itemize{
\item \code{rep}: The replication.
\item \code{n}: The number of observations.
\item \code{nevents}: The number of events.
\item \code{loglik0}: The log-likelihood under null.
\item \code{loglik1}: The maximum log-likelihood.
\item \code{scoretest}: The score test statistic.
}
\item \code{parest}: The data frame of parameter estimates with the
following variables:
\itemize{
\item \code{rep}: The replication.
\item \code{param}: The name of the covariate for the parameter estimate.
\item \code{beta}: The log hazard ratio estimate.
\item \code{sebeta}: The standard error of log hazard ratio estimate.
\item \code{rsebeta}: The robust standard error of log hazard ratio
estimate if robust variance is requested.
\item \code{z}: The Wald test statistic for log hazard ratio. The
\code{rsebeta} will be used if robust variance is requested.
\item \code{hazardRatio}: The hazard ratio estimate.
\item \code{vbeta}: The covariance matrix for parameter estimates.
\item \code{rvbeta}: The robust covariance matrix for parameter
estimates if robust variance is requested.
}
}
}
\description{
Obtains the hazard ratio estimates from the proportional
hazards regression model with right censored or counting process data.
}
\examples{

library(dplyr)

# Example 1 with right-censored data
phregr(data = rawdata \%>\% mutate(treat = 1*(treatmentGroup == 1)),
       rep = "iterationNumber", stratum = "stratum",
       time = "timeUnderObservation", event = "event",
       covariates = "treat")

# Example 2 with counting process data and robust variance estimate
phregr(data = heart \%>\% mutate(rx = as.numeric(transplant) - 1),
       time = "start", time2 = "stop", event = "event",
       covariates = c("rx", "age"), id = "id", robust = 1)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
