% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsbclust.R
\name{lsbclust}
\alias{lsbclust}
\title{Least-squares Bilinear Clustering of Three-way Data}
\usage{
lsbclust(data, margin = 3L, delta = c(1L, 1L, 1L, 1L), nclust, ndim = 2L,
  fixed = c("none", "rows", "columns"), nstart = 20L, starts = NULL,
  nstart.kmeans = 500L, alpha = 0.5, parallel = FALSE, maxit = 100L,
  verbose = 1, method = "diag", type = NULL, sep.nclust = TRUE, ...)
}
\arguments{
\item{data}{A three-way array representing the data.}

\item{margin}{An integer giving the single subscript of \code{data} over which the clustering 
will be applied.}

\item{delta}{A four-element binary vector (logical or numeric) indicating which sum-to-zero 
constraints must be enforced.}

\item{nclust}{A vector of length four giving the number of clusters for the overall mean, the row
margins, the column margins and the interactions (in that order) respectively. Alternatively, a
vector of length one, in which case all components will have the same number of clusters.}

\item{ndim}{The required rank for the approximation of the interactions (a scalar).}

\item{fixed}{One of \code{"none"}, \code{"rows"} or \code{"columns"} indicating whether to fix neither
sets of coordinates, or whether to fix the row or column coordinates across clusters respectively.
If a vector is supplied, only the first element will be used (passed to \code{\link{int.lsbclust}}).}

\item{nstart}{The number of random starts to use for the interaction clustering.}

\item{starts}{A list containing starting configurations for the cluster membership vector. If not
supplied, random initializations will be generated (passed to \code{\link{int.lsbclust}}).}

\item{nstart.kmeans}{The number of random starts to use in \code{\link{kmeans}}.}

\item{alpha}{Numeric value in [0, 1] which determines how the singular values are distributed
between rows and columns (passed to \code{\link{int.lsbclust}}).}

\item{parallel}{Logical indicating whether to parallel over different starts or not 
(passed to \code{\link{int.lsbclust}}).}

\item{maxit}{The maximum number of iterations allowed in the interaction clustering.}

\item{verbose}{Integer controlling the amount of information printed: 0 = no information, 
1 = Information on random starts and progress, and 2 = information is printed after
each iteration for the interaction clustering.}

\item{method}{The method for calculating cluster agreement across random starts, passed on
to \code{\link{cl_agreement}} (passed to \code{\link{int.lsbclust}}).}

\item{type}{One of \code{"rows"}, \code{"columns"} or \code{"overall"} (or a unique abbreviation of 
one of these) indicating whether clustering should be done on row margins, column margins or
the overall means of the two-way slices respectively. If more than one opion are supplied, the
algorithm is run for all (unique) options supplied (passed to \code{\link{orc.lsbclust}}). This
is an optional argument.}

\item{sep.nclust}{Logical indicating how nclust should be used across different \code{type}'s.
If \code{sep.nclust} is \code{TRUE}, \code{nclust} is recycled so that each \code{type} can
have a different number of clusters. If \code{sep.nclust} is \code{FALSE}, the same vector
\code{nclust} is used for all \code{type}'s.}

\item{\dots}{Additional arguments passed to \code{\link{kmeans}}.}
}
\value{
Returns an object of S3 class \code{lsbclust} which has slots:
   \item{\code{overall}}{Object of class \code{ovl.kmeans} for the overall means clustering}
   \item{\code{rows}}{Object of class \code{row.kmeans} for the row means clustering}
   \item{\code{columns}}{Object of class \code{col.kmeans} for the column means clustering}
   \item{\code{interactions}}{Object of class \code{int.lsbclust} for the interaction clustering}
   \item{\code{call}}{The function call used to create the object}
   \item{\code{delta}}{The value of \code{delta} in the fit}
   \item{\code{df}}{Breakdown of the degrees-of-freedom across the different subproblems}
   \item{\code{loss}}{Breakdown of the loss across subproblems}
   \item{\code{time}}{Time taken in seconds to calculate the solution}
   \item{\code{cluster}}{Matrix of cluster membership per observation for all cluster types}
}
\description{
This function clusters along one way of a three-way array (as specified by \code{margin}) while
decomposing along the other two dimensions. Four types of clusterings are allowed based on the
respective two-way slices of the array: on the overall means, row margins, column margins and the 
interactions between rows and columns. Which clusterings can be fit is determined by the vector
\code{delta}, with four binary elements. All orthogonal models are fitted. 
The nonorthogonal case \code{delta = (1, 1, 0, 0)} returns an error. See the reference for further details.
}
\references{
Schoonees, P.C., Groenen, P.J.F., Van de Velden, M. Least-squares Bilinear Clustering
of Three-way Data. Econometric Institute Report, EI2014-23.
}
\seealso{
\code{\link{int.lsbclust}}, \code{\link{orc.lsbclust}}
}
