% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_json.R
\name{make_json}
\alias{make_json}
\title{Make a JSON File with Specified Contents}
\usage{
make_json(x = NULL, file = NULL, git_ignore = FALSE)
}
\arguments{
\item{x}{(character) named vector from which to generate JSON content. Vector elements become JSON values and the vector element names become JSON names. A named vector can be created like so: \code{c("greeting" = "hello", "farewell" = "goodbye")}. The characters on the left of the equal signs are names and the characters on the right are values.}

\item{file}{(character) name of JSON file to create with contents provided to \code{x}. Must end with ".json"}

\item{git_ignore}{(logical) whether to add the file name (defined in \code{file}) to the '.gitignore' if one exists. Defaults to FALSE}
}
\value{
Nothing. Called for side-effects (i.e., creating JSON file)
}
\description{
Creates a JSON (JavaScript Object Notation) file containing the specified name/value pairs. These files are hugely flexible and interpretable by a wide variety of coding languages and thus extremely useful in many contexts. This function is meant to assist those who wish to use JSON files to store user-specific information (e.g., email addresses, absolute file paths, etc.) in collaborative contexts.
}
\examples{
# Create contents
my_info <- c("data_path" = "Users/me/documents/my_project/data")

# Generate a local folder for exporting
temp_folder <- tempdir()

# Create a JSON with those contents
make_json(x = my_info, file = file.path(temp_folder, "user.json"), git_ignore = FALSE)

# Read it back in
(user_info <- RJSONIO::fromJSON(content = file.path(temp_folder, "user.json")))

}
