% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCI_TFL.R
\name{Table1}
\alias{Table1}
\title{Table1}
\usage{
Table1(df, ycol, xcol, xlabels, result_dir, verbose = TRUE)
}
\arguments{
\item{df}{a data.frame}

\item{ycol}{a grouping variable}

\item{xcol}{variables to be compared}

\item{xlabels}{levels of ycol}

\item{result_dir}{directory to save the result}

\item{verbose}{logical, controlling the output}
}
\value{
excel file
}
\description{
Make Table1
}
\details{
This function is used to make Table1 and return excel file.
}
\examples{
\donttest{
data("melanoma", package = "boot")
melanoma2 <- melanoma
# Factor the basic variables that
# we're interested in
melanoma2$status <-
  factor(melanoma2$status,
         levels=c(2,1,3),
         labels=c("Alive", # Reference
                  "Melanoma death",
                  "Non-melanoma death"))
test= Table1(
  df= melanoma2,
  xcol= setdiff(names(melanoma2), "status"),
  ycol= "status",
  result_dir= tempdir()
)
}
}
\author{
Zhen Lu
}
