% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple.R
\docType{class}
\name{simple}
\alias{simple}
\title{The simple logger.}
\format{An \code{R6} class object.}
\usage{
simple
}
\description{
The simple logger registers the expression
applied to an object; a \code{POSIXct} timestamp and
a logical indicating whether the input is identical to the
output.
}
\section{Creating a logger}{


\code{simple$new(verbose=TRUE)}
\tabular{ll}{
  \code{verbose}\tab toggle verbosity
}
}

\section{Dump options}{
 

\code{$dump(file="simple_log.csv",...)}
\tabular{ll}{
\code{file}\tab filename or \code{\link[base]{connection}} to write output to.\cr
\code{...}\tab extra options passed to \code{\link[utils]{write.csv}}, except
\code{row.names}, which is set to \code{FALSE}.\cr
}
}

\section{Get data}{

\code{$logdata()} Returns a \code{data.frame}.
}

\examples{

logfile <- tempfile(fileext=".csv")
out <- women \%>>\%
  start_log(log=simple$new(verbose=FALSE)) \%>>\%
  identity() \%>>\%
  head() \%>>\% 
  dump_log(file=logfile, stop=TRUE)


read.csv(logfile,stringsAsFactors=FALSE)

}
\seealso{
Other loggers: \code{\link{cellwise}},
  \code{\link{filedump}}
}
\keyword{datasets}
