% Generated by roxygen2 (4.0.1): do not edit by hand
\name{lunar.distance}
\alias{lunar.distance}
\title{Lunar Distance}
\usage{
lunar.distance(x, shift = 0, ..., name = FALSE, strict = FALSE)
}
\arguments{
\item{x}{A vector of \code{\link[base]{Date}} values.}

\item{shift}{The number of hours by which to shift the distance calculation.
By default distance is calculated at 12 noon UT.}

\item{name}{Optional parameter indicating whether the return is a factor variable
consisting of a lunar distance label, or the lunar distance in earth
radii.  By default lunar phase is returned in earth radii.}

\item{strict}{Optional parameter indicating whether the return should employ strict
definitions for distance labels, that is, with apogee and perigee
within 5% of their extreme values.  By default the alternative
definition breaks the distance categories evenly into 20%-iles.
The 'average' category is the same in both definitions.}

\item{...}{Other optional arguments are ignored.}
}
\description{
Returns the distance of the moon from the earth on specified dates.
}
\details{
Distance to the moon is returned in units of earth radii, or
  as a 5-level factor variable referring to the moon's
  perigee (at about \eqn{56} earth radii) and
  apogee (at about \eqn{63.8} earth radii).

  Adapted from Stephen R. Schmitt: Lunar Phase Computation:
  \url{http://mysite.verizon.net/res148h4j/zenosamples/zs_lunarphasecalc.html}.
  Last accessed: 1 September 2014.
}
\examples{
lunar.distance(as.Date("2004-03-24"))
}
\seealso{
\code{\link{lunar.distances}}
}
\keyword{lunar}
\keyword{moon}

