% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module.R
\name{fit.luz_module_generator}
\alias{fit.luz_module_generator}
\title{Fit a \code{nn_module}}
\usage{
\method{fit}{luz_module_generator}(
  object,
  data,
  epochs = 10,
  callbacks = NULL,
  valid_data = NULL,
  accelerator = NULL,
  verbose = NULL,
  ...,
  dataloader_options = NULL
)
}
\arguments{
\item{object}{An \code{nn_module} that has been \code{\link[=setup]{setup()}}.}

\item{data}{(dataloader, dataset or list) A dataloader created with
\code{\link[torch:dataloader]{torch::dataloader()}} used for training the model, or a dataset created
with \code{\link[torch:dataset]{torch::dataset()}} or a list. Dataloaders and datasets must return a
list with at most 2 items. The first item will be used as input for the
module and the second will be used as a target for the loss function.}

\item{epochs}{(int) The maximum number of epochs for training the model. If a
single value is provided, this is taken to be the \code{max_epochs} and
\code{min_epochs} is set to 0. If a vector of two numbers is provided, the first
value is \code{min_epochs} and the second value is \code{max_epochs}. The minimum and
maximum number of epochs are included in the context object as
\code{ctx$min_epochs} and \code{ctx$max_epochs}, respectively.}

\item{callbacks}{(list, optional) A list of callbacks defined with
\code{\link[=luz_callback]{luz_callback()}} that will be called during the training procedure. The
callbacks \code{\link[=luz_callback_metrics]{luz_callback_metrics()}}, \code{\link[=luz_callback_progress]{luz_callback_progress()}} and
\code{\link[=luz_callback_train_valid]{luz_callback_train_valid()}} are always added by default.}

\item{valid_data}{(dataloader, dataset, list or scalar value; optional) A
dataloader created with \code{\link[torch:dataloader]{torch::dataloader()}} or a dataset created with
\code{\link[torch:dataset]{torch::dataset()}} that will be used during the validation procedure. They
must return a list with (input, target). If \code{data} is a torch dataset or a
list, then you can also supply a numeric value between 0 and 1 - and in
this case a random sample with size corresponding to that proportion from
\code{data} will be used for validation.}

\item{accelerator}{(accelerator, optional) An optional \code{\link[=accelerator]{accelerator()}} object
used to configure device placement of the components like \link{nn_module}s,
optimizers and batches of data.}

\item{verbose}{(logical, optional) An optional boolean value indicating if
the fitting procedure should emit output to the console during training.
By default, it will produce output if \code{\link[=interactive]{interactive()}} is \code{TRUE}, otherwise
it won't print to the console.}

\item{...}{Currently unused.}

\item{dataloader_options}{Options used when creating a dataloader. See
\code{\link[torch:dataloader]{torch::dataloader()}}. \code{shuffle=TRUE} by default for the training data and
\code{batch_size=32} by default. It will error if not \code{NULL} and \code{data} is
already a dataloader.}
}
\value{
A fitted object that can be saved with \code{\link[=luz_save]{luz_save()}} and can be
printed with \code{\link[=print]{print()}} and plotted with \code{\link[=plot]{plot()}}.
}
\description{
Fit a \code{nn_module}
}
\seealso{
\code{\link[=predict.luz_module_fitted]{predict.luz_module_fitted()}} for how to create predictions.
\code{\link[=setup]{setup()}} to find out how to create modules that can be trained with \code{fit}.

Other training: 
\code{\link{evaluate}()},
\code{\link{predict.luz_module_fitted}()},
\code{\link{setup}()}
}
\concept{training}
