% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.lsjm.R
\name{plot.lsjm}
\alias{plot.lsjm}
\title{Two dimensional plot of Latent Space Joint Model output}
\usage{
\method{plot}{lsjm}(x, Y, drawCB = FALSE, dimZ = c(1, 2),
  plotZtilde = FALSE, colPl = 1, colEll = rgb(0.6, 0.6, 0.6, alpha =
  0.1), LEVEL = 0.95, pchplot = 20, pchEll = 19, pchPl = 19,
  cexPl = 1.1, mainZtilde = NULL, arrowhead = FALSE, curve = NULL,
  xlim = NULL, ylim = NULL, main = NULL, ...)
}
\arguments{
\item{x}{object of class \code{'lsjm'}}

\item{Y}{list containing a (\code{N} x \code{N}) binary adjacency matrix for each network view.}

\item{drawCB}{logical if \code{drawCB = TRUE} draw confidence bounds}

\item{dimZ}{dimensions of the latent variable to be plotted. Default \code{dimZ = c(1, 2)}}

\item{plotZtilde}{if TRUE do the plot for the last step of LSM}

\item{colPl}{\code{col} for the points representing the nodes. Default \code{colPl = NULL}}

\item{colEll}{\code{col} for the ellipses. Default \code{rgb(.6, .6 ,.6 , alpha=.1)}}

\item{LEVEL}{levels of confidence bounds shown when plotting the ellipses. Default \code{LEVEL = .95}}

\item{pchplot}{Default \code{pchplot = 20}}

\item{pchEll}{\code{pch} for the ellipses. Default \code{pchEll = 19}}

\item{pchPl}{\code{pch} for the points representing the nodes. Default \code{pchPl = 19}}

\item{cexPl}{\code{cex} for the points representing the nodes. Default \code{cexPl = 1.1}}

\item{mainZtilde}{title for single network plots TRUE do the plot for the last step of LSM}

\item{arrowhead}{logical, if the arrowed are to be plotted. Default \code{arrowhead = FALSE}}

\item{curve}{curvature of edges. Default \code{curve = 0}}

\item{xlim}{range for x}

\item{ylim}{range for y}

\item{main}{main title}

\item{...}{Arguments to be passed to methods, such as graphical parameters (see \code{\link{par}}).}
}
\description{
Function to plot an object of class \code{'lsjm'}
}
\examples{
## Simulate Undirected Network
  N <- 20
  Ndata <- 2
   Y <- list()
   Y[[1]] <- network(N, directed = FALSE)[,]
   ### create a new view that is similar to the original
  for(nd in 2:Ndata){
    Y[[nd]] <- Y[[nd - 1]] - sample(c(-1, 0, 1), N * N, replace = TRUE, 
    prob = c(.05, .85, .1))
    Y[[nd]] <- 1 * (Y[[nd]]  > 0 )
  diag(Y[[nd]]) <- 0
   }

par(mfrow = c(1, 2))
z <- plotY(Y[[1]], verbose = TRUE, main = 'Network 1')
plotY(Y[[2]], EZ = z, main = 'Network 2')
par(mfrow = c(1, 1))

modLSJM <- lsjm(Y, D = 2) 
plot(modLSJM, Y, drawCB = TRUE)
plot(modLSJM, Y, drawCB = TRUE, plotZtilde = TRUE)
}
