% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mHMMbayes-package.R
\docType{package}
\name{mHMMbayes-package}
\alias{mHMMbayes}
\alias{mHMMbayes-package}
\title{mHMMbayes: Multilevel Hidden Markov Models Using Bayesian Estimation}
\description{
An implementation of the multilevel (also known as mixed or random effects) hidden Markov model using Bayesian estimation in R. The multilevel hidden Markov model (HMM) is a generalization of the well-known hidden Markov model, for the latter see Rabiner (1989) \doi{10.1109/5.18626}. The multilevel HMM is tailored to accommodate (intense) longitudinal data of multiple individuals simultaneously, see e.g., de Haan-Rietdijk et al. \doi{10.1080/00273171.2017.1370364}. Using a multilevel framework, we allow for heterogeneity in the model parameters (transition probability matrix and conditional distribution), while estimating one overall HMM. The model can be fitted on multivariate data with either a categorical, normal, or Poisson distribution, and include individual level covariates (allowing for e.g., group comparisons on model parameters). Parameters are estimated using Bayesian estimation utilizing the forward-backward recursion within a hybrid Metropolis within Gibbs sampler. Missing data (NA) in the dependent variables is accommodated assuming MAR. The package also includes various visualization options, a function to simulate data, and a function to obtain the most likely hidden state sequence for each individual using the Viterbi algorithm.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://CRAN.R-project.org/package=mHMMbayes}
  \item Report bugs at \url{https://github.com/emmekeaarts/mHMMbayes/issues}
}

}
\author{
\strong{Maintainer}: Emmeke Aarts \email{e.aarts@uu.nl}

Authors:
\itemize{
  \item Sebastian Mildiner Moraga
}

}
\keyword{internal}
