% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loop-fetch-msg-metadata.R
\name{loop_fetch_msg_metadata}
\alias{loop_fetch_msg_metadata}
\title{Metadata Fetch Loop}
\usage{
loop_fetch_msg_metadata(new_imapconf, msg_id, by, metadata, write_to_disk,
  keep_in_mem, retries, handle)
}
\arguments{
\item{msg_id}{A numeric vetor containing one or more messages ids.}

\item{by}{Which id (\code{MSN} or \code{UID}) to use when searching for
messages. \code{"MSN"} or message squence number is a message's relative
position to the older message in the mailbox. It may change after deleting
or moving messages. For instance, if a message is deleted, message sequence
numbers are reordered to fill the gap. \code{"UID"} or unique identifier
is always the same during the life cycle of a message. Default is
\code{"MSN"}.}

\item{metadata}{A character vector or string specifying one or more items of
the metadata of a message to fetch. See \link{metadata_options}.}

\item{write_to_disk}{If \code{TRUE} writes fetch content of each message
to the disk as a text file in the working directory. Default is \code{FALSE}.}

\item{keep_in_mem}{If \code{TRUE} keeps a copy of fetch results as an
list in the R session when \code{write_to_disk = TRUE}. Default is
\code{FALSE}. It can only be set \code{TRUE} when
\code{write_to_disk = TRUE}.}

\item{retries}{Number of attempts to connect and execute the command. Default
is \code{2}.}

\item{handle}{A curl handle object.}

\item{imapconf}{An object of class \code{imapconf} generated with
\link{configure_imap} and with a \code{mbox} item added after a
mailbox selection with \link{select_mailbox}.}
}
\value{
A \code{list} or/and text files containing the fetch results.
}
\description{
Internal helper function for loop execution used in fetch
    functions.
}
\seealso{
Other fetch helpers: \code{\link{loop_fetch_full_msg}},
  \code{\link{loop_fetch_msg_header}},
  \code{\link{loop_fetch_msg_text}}

Other loop: \code{\link{loop_fetch_full_msg}},
  \code{\link{loop_fetch_msg_header}},
  \code{\link{loop_fetch_msg_text}}
}
\concept{fetch helpers}
\concept{loop}
\keyword{internal}
