% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/allConstructors.R
\name{saObj}
\alias{saObj}
\title{An ui-constructor for classes sadObj and saeObj}
\usage{
saObj(data, f, smallAreaMeans = NULL, s1 = NULL, s2 = NULL,
  cluster = NULL, include = NULL)
}
\arguments{
\item{data}{See \code{"\linkS4class{saeObj}"}.}

\item{f}{a linear mixed effects formula, but see \bold{Value}.}

\item{smallAreaMeans}{See \code{"\linkS4class{saeObj}"}.}

\item{s1}{See \code{"\linkS4class{saeObj}"}.}

\item{s2}{See \code{"\linkS4class{saeObj}"}.}

\item{cluster}{See \code{"\linkS4class{saeObj}"}.}

\item{include}{See \code{"\linkS4class{saeObj}"}.}
}
\value{
an object of class \code{sadObj} if \code{f} is of structure `x ~ NULL | g',
an object of class \code{saeObj} otherwise.
}
\description{
simple wrapper to \code{new("sa[de]Obj")}.
If missing, it adds an inclusion variable to \code{data};
it checks for missing in the clustering variable.
Adds comments documenting changes made to the returned object.
}
\examples{
library('maSAE')
## load data
data('s2')
## create sadObj object
saeO  <- saObj(data = s2, f = y ~ NULL | g)
## create saeObj object
s2$s2 <- TRUE
saeO <- saObj(data = s2, f = y ~x1 + x2 + x3 | g, s2 = 's2')
}
\seealso{
\code{"\linkS4class{saeObj}"}, \code{"\linkS4class{sadObj}"}.
}

