% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mable-multivar.r
\name{mvbern.poly}
\alias{mvbern.poly}
\title{Multivariate Bernstein polynomial}
\usage{
mvbern.poly(x, obj, density = TRUE)
}
\arguments{
\item{x}{a matrix with \code{d} columns or a vector of length \code{d} within 
supporting hyperrectangle \eqn{[a,b]=[a_1,b_1]\times \cdots\times[a_d,b_d]}}

\item{obj}{a list containing degrees \code{m}, mixture proportions \code{p}, 
and supporting hyperrectangle specified by \code{interval}:
\eqn{[a,b]=[a_1,b_1]\times \cdots\times[a_d,b_d]}  
or a class "mable" object returned by \code{mable.mvar()}}

\item{density}{logical, whether a density or a distribution function to be calculated. Default is TRUE.}
}
\value{
a vector of values of the density or the cumulative distribution function
}
\description{
Multivariate Bernstein polynomial
}
\examples{
## Old Faithful Data
\donttest{
 a<-c(0, 40); b<-c(7, 110)
 ans<-mable.mvar(faithful, m=c(42, 26), search=FALSE, interval=cbind(a,b))
 f<-function(x, y) mvbern.poly(cbind(x, y), ans) 
 x <- seq(a[1], b[1], length= 40)
 y <- seq(a[2], b[2], length= 40)
 z <- outer(x, y, f)
 persp(x, y, z, theta = 30, phi = 20, expand = 0.5, col = "lightblue",
       ltheta = 90, shade = 0.1, ticktype = "detailed", main = expression(paste("MABLE ",hat(f))),
       xlab = "eruptions", ylab = "waiting", zlab = "Joint Density")
}
}
\author{
Zhong Guan <zguan@iusb.edu>
}
\concept{Bernstein polynomial model}
\concept{multivariate Bernstein polynomials}
\keyword{multivariate}
