% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/made.r
\name{made.copula}
\alias{made.copula}
\title{Minimum Approximate Distance Estimate of Copula Density}
\usage{
made.copula(
  x,
  unif.mar = FALSE,
  M = 30,
  search = TRUE,
  interval = NULL,
  pseudo.obs = c("empirical", "mable"),
  sig.level = 0.01
)
}
\arguments{
\item{x}{an \code{n x d} matrix of data values}

\item{unif.mar}{marginals are all uniform (\code{x} contain pseudo observations) 
or not.}

\item{M}{d-vector of preselected or maximum model degrees}

\item{search}{logical, whether to search optimal degrees between \code{0} and \code{M} 
or not but use \code{M} as the given model degrees for the joint density.}

\item{interval}{a 2 by d matrix specifying the support/truncate interval of \code{x}, 
if \code{unif.mar=TRUE} then \code{interval} is the unit hypercube}

\item{pseudo.obs}{When \code{unif.mar=FALSE}, use \code{"empirical"} distribution to 
create pseudo observations, or use \code{"mable"} of marginal cdfs to create 
pseudo observations}

\item{sig.level}{significance level for p-value of change-point}
}
\value{
An invisible \code{mable} object with components
\itemize{
  \item \code{m} the given degree
  \item \code{p} the estimated vector of mixture proportions 
     \eqn{p = (p_0, \ldots, p_m)}
      with the given degree \code{m}
  \item \code{D}  the minimum distance at degree \code{m}
 }
}
\description{
Minimum Approximate Distance Estimate of Copula Density
}
\details{
With given model degrees \code{m}, the parameters \code{p}, the mixing
  proportions of the beta distribution, are calculated as the minimizer of the
  approximate \eqn{L_2} distance between the empirical distribution and 
  the Bernstein polynomial model. The optimal model degrees \code{m} are chosen by
  a change-point method. The quadratic programming with linear constraints is 
  used to solve the problem.
}
