% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mable.r
\name{momodem}
\alias{momodem}
\title{Method of mode estimate of a Bernstein polynomial model degree}
\usage{
momodem(modes, x)
}
\arguments{
\item{modes}{a list containing \code{z}, a vector of the known or estimated 
locations of modes,  \code{ufz}, a vector of upper confidence limits
of density values at modes, and \code{fz}, a vector of estimated density 
values at modes by \code{ks::kde} or \code{multimode::locmodes()}}

\item{x}{a vector sample values}
}
\value{
A list with components
\itemize{
  \item \code{mode} a vector of modes
  \item \code{nmod} the number of modes in \code{mode}
  \item \code{m}  the method of mode estimate of degree 
  \item \code{lam} a vector of rough estimates of the mixing proportions 
 }
}
\description{
Select a Bernstein polynomial model degree for density  
   on [0,1] based on mode(s) used as an initial guess for the iterative method
   of moment of choosing the model degree
}
\author{
Zhong Guan <zguan@iu.edu>
}
\keyword{internal}
