% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolendmessage.R
\name{toolendmessage}
\alias{toolendmessage}
\title{Tool: End message}
\usage{
toolendmessage(startdata, level = NULL, id = "none")
}
\arguments{
\item{startdata}{a list containing diagnostic information provided by \code{\link{toolstartmessage}}}

\item{level}{This argument allows to establish a hierarchy of print
statements. The hierarchy is preserved for the next vcat executions.
Currently this setting can have 4 states: NULL (nothing will be changed), 0
(reset hierarchies), "+" (increase hierarchy level by 1) and "-" (decrease
hierarchy level by 1).}

\item{id}{additional id which uniquely identifies the process that just has been finished}
}
\description{
Function writes a process end message and performs some diagnostics
}
\examples{

\dontrun{
tmp <- function(bla=NULL) {
  startinfo <- toolstartmessage("+")
  print(bla)
  toolendmessage(startinfo,"-")
  }
tmp(bla=99)
}

}
\seealso{
\code{\link{toolstartmessage}}, \code{\link{vcat}}
}
\author{
Jan Philipp Dietrich
}
